import React from "react";

/**
 * reusing the 'ref' from 'forwardRef' with React hooks
 * combinedRef will consist current property
 * ex:
 * const innerRef = React.useRef(null)
 * const combinedRef = useCombinedRefs(ref, innerRef)
 *
 * @param refs
 */
export function useCombinedRefs(...refs: (React.MutableRefObject<HTMLDivElement | null> | Function)[]) {
  const targetRef = React.useRef<HTMLDivElement | null>(null);

  React.useEffect(() => {
    refs.forEach((ref) => {
      if (!ref) return;

      if (typeof ref === 'function') {
        ref(targetRef.current)
      } else {
        ref.current = targetRef.current
      }
    })
  }, [refs]);

  return targetRef;
}
