/**
 * based on
 * microevent.js - https://github.com/jeromeetienne/microevent.js
 */

export class MicroEvent {
  private _events: {} = {};

  addEventListener(event: string, fct: Function) {
    if (this._events === undefined) this._events = {};
    this._events[event] = this._events[event] || [];
    this._events[event].push(fct);
    return fct;
  };

  removeEventListener(event: string, fct: Function) {
    if (this._events === undefined) this._events = {};
    if (event in this._events === false) return;
    this._events[event].splice(this._events[event].indexOf(fct), 1);
  };

  dispatchEvent(event: string, ...args: any[] /* , args... */) {
    if (this._events === undefined) this._events = {};
    if (this._events[event] === undefined) return;
    const tmpArray = this._events[event].slice();
    for (let i = 0; i < tmpArray.length; i++) {
      const result = tmpArray[i].apply(this, Array.prototype.slice.call(arguments, 1));
      if (result !== undefined) return result;
    }
    return undefined;
  };
}
