import React from "react";
import {cleanup, screen} from "@testing-library/react";
import TestRenderer, {act} from "react-test-renderer";
import {MockedProvider} from "@apollo/client/testing";
import {TestLogin} from "components/testLogin";
import {InMemoryCache} from "@apollo/client";
import {toMaybe} from "utils";
import {
  StoreDocument,
  StoreQuery,
  StoreQueryVariables, SystemStatusDocument
} from "@generated/graphql";
import {Apollo} from "@core/api";
import resolvers from "graphql/resolvers";

const cache = new InMemoryCache({typePolicies: {
  store: {
    keyFields: [],
  },
  StoreDocument: {
    queryType: true
  }
}}).restore({
  store:
    {
      "__typename": "AppStore",
      "session": {
        "__typename": "Session",
        "isLoggedIn": true,
        "info": {
          "__typename": "SessionInfo",
          "user": {
            "__typename": "ObjUUIDAndName",
            "obj": "41c2edf2-9098-11eb-a2ef-00155dd9270b",
            "name": "danil"
          },
          "role": {
            "__typename": "ObjUUIDAndName",
            "obj": "e43e12e7-75b9-11ea-aa7f-00155dd9270b",
            "name": "Admin Role"
          },
          "realm": {
            "__typename": "ObjUUIDAndName",
            "obj": "e43e12e6-75b9-11ea-aa7f-00155dd9270b",
            "name": "realm_test"
          }
        }
      },
      "select": null,
      "workspace": {
        "__typename": "Workspace",
        "event": null,
        "updatedEvent": null,
        "creatingViews": null,
        "solidConfigJSON": "{\"v2\":{\"views\":[{\"id\":\"start\",\"name\":\"Start Page\",\"module\":\"Views/ViewStart\",\"isSystem\":true,\"hideCloseButton\":true,\"hideHeaderControls\":true}],\"allViews\":[{\"id\":\"start\",\"name\":\"Start Page\",\"module\":\"Views/ViewStart\",\"isSystem\":true,\"hideCloseButton\":true,\"hideHeaderControls\":true},{\"id\":\"camerasAndEventLog\",\"name\":\"Cameras & Event List\",\"module\":\"ViewLayouts/ViewCustom\",\"hasLayout\":true,\"isSystem\":true,\"isShared\":true,\"aspectRatio\":1.7777777777777777,\"layout\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":1,\"items\":[{\"type\":\"Cell\",\"size\":0.15},{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":0.7,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.4,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.4,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]},{\"type\":\"Cell\",\"size\":0.2}]},{\"type\":\"Cell\",\"size\":0.15}]}],\"widgets\":[{\"id\":\"\",\"name\":\"\",\"module\":\"CameraList\",\"widgetId\":\"DeviceList\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"\",\"name\":\"\",\"module\":\"EventList\",\"widgetId\":\"EventList\"},{\"id\":\"\",\"name\":\"\",\"module\":\"EventInfo\",\"widgetId\":\"EventDetails\"}]},{\"id\":\"cameraGrid\",\"name\":\"Camera Grid\",\"module\":\"ViewLayouts/ViewCustom\",\"hasLayout\":true,\"isSystem\":true,\"isShared\":true,\"aspectRatio\":1.7777777777777777,\"layout\":[{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":1,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.3,\"items\":[{\"type\":\"Cell\",\"size\":0.15},{\"type\":\"Cell\",\"size\":0.7},{\"type\":\"Cell\",\"size\":0.15}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.3,\"items\":[{\"type\":\"Cell\",\"size\":0.3},{\"type\":\"Cell\",\"size\":0.3},{\"type\":\"Cell\",\"size\":0.3}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.3,\"items\":[{\"type\":\"Cell\",\"size\":0.3},{\"type\":\"Cell\",\"size\":0.3},{\"type\":\"Cell\",\"size\":0.3}]}]}],\"widgets\":[{\"id\":\"\",\"name\":\"\",\"module\":\"CameraList\",\"widgetId\":\"DeviceList\"},{\"id\":\"\",\"name\":\"\",\"module\":\"EventList\",\"widgetId\":\"EventList\"},{\"id\":\"\",\"name\":\"\",\"module\":\"EventInfo\",\"widgetId\":\"EventDetails\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"}]},{\"id\":\"eventLog\",\"name\":\"Event List\",\"module\":\"ViewLayouts/ViewCustom\",\"hasLayout\":true,\"isSystem\":true,\"isShared\":true,\"aspectRatio\":1.7777777777777777,\"layout\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":1,\"items\":[{\"type\":\"Cell\",\"size\":0.85},{\"type\":\"Cell\",\"size\":0.15}]}],\"widgets\":[{\"id\":\"\",\"name\":\"\",\"module\":\"EventList\",\"widgetId\":\"EventList\"},{\"id\":\"\",\"name\":\"\",\"module\":\"EventInfo\",\"widgetId\":\"EventDetails\"}]}],\"timestamp\":1619082629672}}",
        "localViewsJSON": null,
        "sharedViewsJSON": "{\"v2\":{\"sharedViews\":[{\"id\":\"0bdf6540-75bd-11ea-89e3-fb949e7caafa\",\"name\":\"View #1\",\"module\":\"ViewLayouts/ViewCustom\",\"hasLayout\":true,\"widgets\":[{\"id\":\"4d2763f0-75bc-11ea-89e3-fb949e7caafa_DeviceList0\",\"name\":\"Device List\",\"module\":\"CameraList\",\"widgetId\":\"DeviceList\"},{\"id\":\"4d2763f0-75bc-11ea-89e3-fb949e7caafa_CameraLive1\",\"name\":\"Camera 1\",\"module\":\"CellContainer/CameraLive\",\"widgetId\":\"CameraLive\",\"props\":{\"object\":{\"type\":\"Camera\",\"obj\":{\"data-id\":\"0e8005ae-75bb-11ea-aa7f-00155dd9270b\",\"name\":\"DEMO Airport_2\"}}}},{\"id\":\"4d2763f0-75bc-11ea-89e3-fb949e7caafa_CameraLive2\",\"name\":\"Camera 2\",\"module\":\"CellContainer/CameraLive\",\"widgetId\":\"CameraLive\"},{\"id\":\"4d2763f0-75bc-11ea-89e3-fb949e7caafa_CameraLive3\",\"name\":\"Camera 3\",\"module\":\"CellContainer/CameraLive\",\"widgetId\":\"CameraLive\"},{\"id\":\"4d2763f0-75bc-11ea-89e3-fb949e7caafa_CameraLive4\",\"name\":\"Camera 4\",\"module\":\"CellContainer/CameraLive\",\"widgetId\":\"CameraLive\"}],\"templateId\":\"Custom\",\"layoutId\":\"ViewSingle\",\"layout\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":1,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]}]}]}],\"aspectRatio\":1.7777777777777777,\"userId\":\"826b0bd6-75ba-11ea-aa7f-00155dd9270b\",\"index\":0,\"isShared\":true,\"originalViewId\":\"4d2763f0-75bc-11ea-89e3-fb949e7caafa\"},{\"id\":\"40ec3780-75be-11ea-a0ab-a9d786fcbeb2\",\"name\":\"View #2\",\"module\":\"ViewLayouts/ViewCustom\",\"hasLayout\":true,\"widgets\":[{\"id\":\"d0327d60-75bd-11ea-a0ab-a9d786fcbeb2_EventList0\",\"name\":\"Event List\",\"module\":\"EventList\",\"widgetId\":\"EventList\"},{\"id\":\"d0327d60-75bd-11ea-a0ab-a9d786fcbeb2_EventDetails1\",\"name\":\"Event Details\",\"module\":\"EventInfo\",\"widgetId\":\"EventDetails\"},{\"id\":\"d0327d60-75bd-11ea-a0ab-a9d786fcbeb2_EventVideo2\",\"name\":\"Event Video\",\"module\":\"CellContainer/EventVideo\",\"widgetId\":\"EventVideo\"}],\"templateId\":\"Custom\",\"layoutId\":\"ViewSingle\",\"layout\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":1,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]}]}],\"aspectRatio\":1.7777777777777777,\"userId\":\"826b0bd6-75ba-11ea-aa7f-00155dd9270b\",\"index\":0,\"isShared\":true,\"originalViewId\":\"d0327d60-75bd-11ea-a0ab-a9d786fcbeb2\"},{\"id\":\"159b7ca0-c828-11ea-8cd2-956dc6b692bd\",\"name\":\"Archive Viewer\",\"module\":\"ViewLayouts/ViewCustom\",\"hasLayout\":true,\"widgets\":[{\"id\":\"159b7ca0-c828-11ea-8cd2-956dc6b692bd_ArchiveViewer0\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"ArchiveViewer\",\"props\":{\"object\":{\"type\":\"Camera\",\"obj\":{\"data-id\":\"65b938f8-b496-11ea-a0f2-00155dd9270b\",\"name\":\"DEMO Airport_2\"}}}},{\"id\":\"159b7ca0-c828-11ea-8cd2-956dc6b692bd_ArchiveViewer1\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"ArchiveViewer\",\"props\":{\"object\":{\"type\":\"Camera\",\"obj\":{\"data-id\":\"e390d7dc-9fa5-11ea-aa14-00155dd9270b\",\"name\":\"DEMO Airport\"}}}},{\"id\":\"159b7ca0-c828-11ea-8cd2-956dc6b692bd_ArchiveViewer2\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"ArchiveViewer\",\"props\":{\"object\":{\"type\":\"Camera\",\"obj\":{\"data-id\":\"99c24838-b496-11ea-a0f2-00155dd9270b\",\"name\":\"DEMO field\"}}}},{\"id\":\"159b7ca0-c828-11ea-8cd2-956dc6b692bd_ArchiveViewer3\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"ArchiveViewer\",\"props\":{\"object\":{\"type\":\"Camera\",\"obj\":{\"data-id\":\"20884c9c-b496-11ea-a0f2-00155dd9270b\",\"name\":\"DEMO LPR3\"}}}},{\"id\":\"159b7ca0-c828-11ea-8cd2-956dc6b692bd_EventList4\",\"name\":\"\",\"module\":\"EventList\",\"widgetId\":\"EventList\",\"props\":{\"eventView\":\"Tiles\"}},{\"id\":\"159b7ca0-c828-11ea-8cd2-956dc6b692bd_DeviceList5\",\"name\":\"\",\"module\":\"CameraList\",\"widgetId\":\"DeviceList\"},{\"id\":\"159b7ca0-c828-11ea-8cd2-956dc6b692bd_Timeline6\",\"name\":\"\",\"module\":\"Timeline\",\"widgetId\":\"Timeline\",\"props\":{\"controlsPosition\":\"Bottom\",\"limitWidth\":false}}],\"templateId\":\"Custom\",\"layoutId\":\"View2x2\",\"layout\":[{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":1,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]}]},{\"type\":\"Cell\",\"size\":0.25},{\"type\":\"Cell\",\"size\":0.25}]},{\"type\":\"Cell\",\"size\":0.5}]}],\"aspectRatio\":1.7777777777777777,\"userId\":\"826b0bd6-75ba-11ea-aa7f-00155dd9270b\",\"isShared\":true},{\"id\":\"297cfc20-5b45-11eb-ae1a-c32672cb2132\",\"name\":\"4x4\",\"module\":\"ViewLayouts/ViewCustom\",\"hasLayout\":true,\"widgets\":[{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_DeviceList0\",\"name\":\"\",\"module\":\"CameraList\",\"widgetId\":\"DeviceList\",\"props\":{\"fixedWidth\":200,\"limitWidth\":true,\"hierarchyId\":0}},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive1\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive2\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive3\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive4\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive5\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive6\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive7\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive8\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive9\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive10\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive11\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive12\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive13\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive14\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive15\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive16\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"}],\"templateId\":\"Custom\",\"layoutId\":\"ViewSingle\",\"layout\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":1,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]}]},{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]}]}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]}]},{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]}]}]}]}]}],\"aspectRatio\":1.7777777777777777,\"userId\":\"89fac846-75ba-11ea-aa7f-00155dd9270b\",\"isShared\":true,\"originalViewId\":\"82c67f20-938d-11ea-9363-f1bc3da8a790\"},{\"id\":\"52867ee0-fd92-11ea-9c01-db32bc746575\",\"name\":\"View #3\",\"module\":\"ViewLayouts/ViewCustom\",\"hasLayout\":true,\"widgets\":[{\"id\":\"4055f890-fd92-11ea-9c01-db32bc746575_DeviceList0\",\"name\":\"\",\"module\":\"CameraList\",\"widgetId\":\"DeviceList\"},{\"id\":\"4055f890-fd92-11ea-9c01-db32bc746575_CameraLive1\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"}],\"templateId\":\"Custom\",\"layoutId\":\"ViewSingle\",\"layout\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":1,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]}],\"aspectRatio\":1.7777777777777777,\"userId\":\"bae681a8-fd7c-11ea-843c-00155dd9270b\",\"isShared\":true,\"originalViewId\":\"4055f890-fd92-11ea-9c01-db32bc746575\"}]}}",
        "cameraWidgetProps": null
      },
      "socketEvent": null
    },
});

const data = { store: toMaybe(Apollo.defaultStore()) };

cache.writeQuery<StoreQuery, StoreQueryVariables>({ query: StoreDocument, data });

const mocks = [
  {
    request: {
      query: SystemStatusDocument,
      // variables: {fetchPolicy: "no-cache"},
    },
    result: {
      data: {
        systemStatus: {
          status: "CRITICAL",
          description: "CRITICAL: System in a CRITICAL state.  See details for more information.",
          reasons: [
            {
              message: "Storage is full on Avatar 'nanopineo3'",
              object: {
                id: "1bc9ac84-45a3-4b5f-a9ee-72ec004fd9d1",
                name: "nanopineo3",
              },
            },
            {
              message: "Storage is full on Avatar 'link-test'",
              object: {
                id: "d1b462af-a2e7-4973-860b-6d53e078d376",
                name: "link-test",
              },
            },
            {
              message: "Storage is full on Avatar 'link-mini'",
              object: {
                id: "17f44ffb-7c69-4eb8-ab42-3998735ba801",
                name: "link-mini",
              },
            },
            {
              message: "Storage is full on Avatar 'DESKTOP-1RHVD0K'",
              object: {
                id: "10d33d4c-1886-46e8-9a71-d9b5b31dbd0a",
                name: "DESKTOP-1RHVD0K",
              },
            }
          ],
        },
        serverTime: "2021-04-22T07:28:13.000Z"
      },
    },
  },
  {
    request: {
      query: StoreDocument,
      // variables: {fetchPolicy: "no-cache"},
    },
    result: {
      data: {
        "__typename": "AppStore",
        "session": {
          "__typename": "Session",
          "isLoggedIn": true,
          "info": {
            "__typename": "SessionInfo",
            "user": {
              "__typename": "ObjUUIDAndName",
              "obj": "41c2edf2-9098-11eb-a2ef-00155dd9270b",
              "name": "danil"
            },
            "role": {
              "__typename": "ObjUUIDAndName",
              "obj": "e43e12e7-75b9-11ea-aa7f-00155dd9270b",
              "name": "Admin Role"
            },
            "realm": {
              "__typename": "ObjUUIDAndName",
              "obj": "e43e12e6-75b9-11ea-aa7f-00155dd9270b",
              "name": "realm_test"
            }
          }
        },
        "select": null,
        "workspace": {
          "__typename": "Workspace",
          "event": null,
          "updatedEvent": null,
          "creatingViews": null,
          "solidConfigJSON": "{\"v2\":{\"views\":[{\"id\":\"start\",\"name\":\"Start Page\",\"module\":\"Views/ViewStart\",\"isSystem\":true,\"hideCloseButton\":true,\"hideHeaderControls\":true}],\"allViews\":[{\"id\":\"start\",\"name\":\"Start Page\",\"module\":\"Views/ViewStart\",\"isSystem\":true,\"hideCloseButton\":true,\"hideHeaderControls\":true},{\"id\":\"camerasAndEventLog\",\"name\":\"Cameras & Event List\",\"module\":\"ViewLayouts/ViewCustom\",\"hasLayout\":true,\"isSystem\":true,\"isShared\":true,\"aspectRatio\":1.7777777777777777,\"layout\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":1,\"items\":[{\"type\":\"Cell\",\"size\":0.15},{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":0.7,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.4,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.4,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]},{\"type\":\"Cell\",\"size\":0.2}]},{\"type\":\"Cell\",\"size\":0.15}]}],\"widgets\":[{\"id\":\"\",\"name\":\"\",\"module\":\"CameraList\",\"widgetId\":\"DeviceList\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"\",\"name\":\"\",\"module\":\"EventList\",\"widgetId\":\"EventList\"},{\"id\":\"\",\"name\":\"\",\"module\":\"EventInfo\",\"widgetId\":\"EventDetails\"}]},{\"id\":\"cameraGrid\",\"name\":\"Camera Grid\",\"module\":\"ViewLayouts/ViewCustom\",\"hasLayout\":true,\"isSystem\":true,\"isShared\":true,\"aspectRatio\":1.7777777777777777,\"layout\":[{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":1,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.3,\"items\":[{\"type\":\"Cell\",\"size\":0.15},{\"type\":\"Cell\",\"size\":0.7},{\"type\":\"Cell\",\"size\":0.15}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.3,\"items\":[{\"type\":\"Cell\",\"size\":0.3},{\"type\":\"Cell\",\"size\":0.3},{\"type\":\"Cell\",\"size\":0.3}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.3,\"items\":[{\"type\":\"Cell\",\"size\":0.3},{\"type\":\"Cell\",\"size\":0.3},{\"type\":\"Cell\",\"size\":0.3}]}]}],\"widgets\":[{\"id\":\"\",\"name\":\"\",\"module\":\"CameraList\",\"widgetId\":\"DeviceList\"},{\"id\":\"\",\"name\":\"\",\"module\":\"EventList\",\"widgetId\":\"EventList\"},{\"id\":\"\",\"name\":\"\",\"module\":\"EventInfo\",\"widgetId\":\"EventDetails\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"}]},{\"id\":\"eventLog\",\"name\":\"Event List\",\"module\":\"ViewLayouts/ViewCustom\",\"hasLayout\":true,\"isSystem\":true,\"isShared\":true,\"aspectRatio\":1.7777777777777777,\"layout\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":1,\"items\":[{\"type\":\"Cell\",\"size\":0.85},{\"type\":\"Cell\",\"size\":0.15}]}],\"widgets\":[{\"id\":\"\",\"name\":\"\",\"module\":\"EventList\",\"widgetId\":\"EventList\"},{\"id\":\"\",\"name\":\"\",\"module\":\"EventInfo\",\"widgetId\":\"EventDetails\"}]}],\"timestamp\":1619082629672}}",
          "localViewsJSON": null,
          "sharedViewsJSON": "{\"v2\":{\"sharedViews\":[{\"id\":\"0bdf6540-75bd-11ea-89e3-fb949e7caafa\",\"name\":\"View #1\",\"module\":\"ViewLayouts/ViewCustom\",\"hasLayout\":true,\"widgets\":[{\"id\":\"4d2763f0-75bc-11ea-89e3-fb949e7caafa_DeviceList0\",\"name\":\"Device List\",\"module\":\"CameraList\",\"widgetId\":\"DeviceList\"},{\"id\":\"4d2763f0-75bc-11ea-89e3-fb949e7caafa_CameraLive1\",\"name\":\"Camera 1\",\"module\":\"CellContainer/CameraLive\",\"widgetId\":\"CameraLive\",\"props\":{\"object\":{\"type\":\"Camera\",\"obj\":{\"data-id\":\"0e8005ae-75bb-11ea-aa7f-00155dd9270b\",\"name\":\"DEMO Airport_2\"}}}},{\"id\":\"4d2763f0-75bc-11ea-89e3-fb949e7caafa_CameraLive2\",\"name\":\"Camera 2\",\"module\":\"CellContainer/CameraLive\",\"widgetId\":\"CameraLive\"},{\"id\":\"4d2763f0-75bc-11ea-89e3-fb949e7caafa_CameraLive3\",\"name\":\"Camera 3\",\"module\":\"CellContainer/CameraLive\",\"widgetId\":\"CameraLive\"},{\"id\":\"4d2763f0-75bc-11ea-89e3-fb949e7caafa_CameraLive4\",\"name\":\"Camera 4\",\"module\":\"CellContainer/CameraLive\",\"widgetId\":\"CameraLive\"}],\"templateId\":\"Custom\",\"layoutId\":\"ViewSingle\",\"layout\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":1,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]}]}]}],\"aspectRatio\":1.7777777777777777,\"userId\":\"826b0bd6-75ba-11ea-aa7f-00155dd9270b\",\"index\":0,\"isShared\":true,\"originalViewId\":\"4d2763f0-75bc-11ea-89e3-fb949e7caafa\"},{\"id\":\"40ec3780-75be-11ea-a0ab-a9d786fcbeb2\",\"name\":\"View #2\",\"module\":\"ViewLayouts/ViewCustom\",\"hasLayout\":true,\"widgets\":[{\"id\":\"d0327d60-75bd-11ea-a0ab-a9d786fcbeb2_EventList0\",\"name\":\"Event List\",\"module\":\"EventList\",\"widgetId\":\"EventList\"},{\"id\":\"d0327d60-75bd-11ea-a0ab-a9d786fcbeb2_EventDetails1\",\"name\":\"Event Details\",\"module\":\"EventInfo\",\"widgetId\":\"EventDetails\"},{\"id\":\"d0327d60-75bd-11ea-a0ab-a9d786fcbeb2_EventVideo2\",\"name\":\"Event Video\",\"module\":\"CellContainer/EventVideo\",\"widgetId\":\"EventVideo\"}],\"templateId\":\"Custom\",\"layoutId\":\"ViewSingle\",\"layout\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":1,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]}]}],\"aspectRatio\":1.7777777777777777,\"userId\":\"826b0bd6-75ba-11ea-aa7f-00155dd9270b\",\"index\":0,\"isShared\":true,\"originalViewId\":\"d0327d60-75bd-11ea-a0ab-a9d786fcbeb2\"},{\"id\":\"159b7ca0-c828-11ea-8cd2-956dc6b692bd\",\"name\":\"Archive Viewer\",\"module\":\"ViewLayouts/ViewCustom\",\"hasLayout\":true,\"widgets\":[{\"id\":\"159b7ca0-c828-11ea-8cd2-956dc6b692bd_ArchiveViewer0\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"ArchiveViewer\",\"props\":{\"object\":{\"type\":\"Camera\",\"obj\":{\"data-id\":\"65b938f8-b496-11ea-a0f2-00155dd9270b\",\"name\":\"DEMO Airport_2\"}}}},{\"id\":\"159b7ca0-c828-11ea-8cd2-956dc6b692bd_ArchiveViewer1\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"ArchiveViewer\",\"props\":{\"object\":{\"type\":\"Camera\",\"obj\":{\"data-id\":\"e390d7dc-9fa5-11ea-aa14-00155dd9270b\",\"name\":\"DEMO Airport\"}}}},{\"id\":\"159b7ca0-c828-11ea-8cd2-956dc6b692bd_ArchiveViewer2\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"ArchiveViewer\",\"props\":{\"object\":{\"type\":\"Camera\",\"obj\":{\"data-id\":\"99c24838-b496-11ea-a0f2-00155dd9270b\",\"name\":\"DEMO field\"}}}},{\"id\":\"159b7ca0-c828-11ea-8cd2-956dc6b692bd_ArchiveViewer3\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"ArchiveViewer\",\"props\":{\"object\":{\"type\":\"Camera\",\"obj\":{\"data-id\":\"20884c9c-b496-11ea-a0f2-00155dd9270b\",\"name\":\"DEMO LPR3\"}}}},{\"id\":\"159b7ca0-c828-11ea-8cd2-956dc6b692bd_EventList4\",\"name\":\"\",\"module\":\"EventList\",\"widgetId\":\"EventList\",\"props\":{\"eventView\":\"Tiles\"}},{\"id\":\"159b7ca0-c828-11ea-8cd2-956dc6b692bd_DeviceList5\",\"name\":\"\",\"module\":\"CameraList\",\"widgetId\":\"DeviceList\"},{\"id\":\"159b7ca0-c828-11ea-8cd2-956dc6b692bd_Timeline6\",\"name\":\"\",\"module\":\"Timeline\",\"widgetId\":\"Timeline\",\"props\":{\"controlsPosition\":\"Bottom\",\"limitWidth\":false}}],\"templateId\":\"Custom\",\"layoutId\":\"View2x2\",\"layout\":[{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":1,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]}]},{\"type\":\"Cell\",\"size\":0.25},{\"type\":\"Cell\",\"size\":0.25}]},{\"type\":\"Cell\",\"size\":0.5}]}],\"aspectRatio\":1.7777777777777777,\"userId\":\"826b0bd6-75ba-11ea-aa7f-00155dd9270b\",\"isShared\":true},{\"id\":\"297cfc20-5b45-11eb-ae1a-c32672cb2132\",\"name\":\"4x4\",\"module\":\"ViewLayouts/ViewCustom\",\"hasLayout\":true,\"widgets\":[{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_DeviceList0\",\"name\":\"\",\"module\":\"CameraList\",\"widgetId\":\"DeviceList\",\"props\":{\"fixedWidth\":200,\"limitWidth\":true,\"hierarchyId\":0}},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive1\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive2\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive3\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive4\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive5\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive6\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive7\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive8\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive9\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive10\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive11\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive12\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive13\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive14\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive15\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"},{\"id\":\"82c67f20-938d-11ea-9363-f1bc3da8a790_CameraLive16\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"}],\"templateId\":\"Custom\",\"layoutId\":\"ViewSingle\",\"layout\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":1,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]}]},{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]}]}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]}]},{\"type\":\"Split\",\"orientation\":\"vertical\",\"size\":0.5,\"items\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]},{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":0.5,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]}]}]}]}]}],\"aspectRatio\":1.7777777777777777,\"userId\":\"89fac846-75ba-11ea-aa7f-00155dd9270b\",\"isShared\":true,\"originalViewId\":\"82c67f20-938d-11ea-9363-f1bc3da8a790\"},{\"id\":\"52867ee0-fd92-11ea-9c01-db32bc746575\",\"name\":\"View #3\",\"module\":\"ViewLayouts/ViewCustom\",\"hasLayout\":true,\"widgets\":[{\"id\":\"4055f890-fd92-11ea-9c01-db32bc746575_DeviceList0\",\"name\":\"\",\"module\":\"CameraList\",\"widgetId\":\"DeviceList\"},{\"id\":\"4055f890-fd92-11ea-9c01-db32bc746575_CameraLive1\",\"name\":\"\",\"module\":\"CellContainer/CameraCell\",\"widgetId\":\"CameraLive\"}],\"templateId\":\"Custom\",\"layoutId\":\"ViewSingle\",\"layout\":[{\"type\":\"Split\",\"orientation\":\"horizontal\",\"size\":1,\"items\":[{\"type\":\"Cell\",\"size\":0.5},{\"type\":\"Cell\",\"size\":0.5}]}],\"aspectRatio\":1.7777777777777777,\"userId\":\"bae681a8-fd7c-11ea-843c-00155dd9270b\",\"isShared\":true,\"originalViewId\":\"4055f890-fd92-11ea-9c01-db32bc746575\"}]}}",
          "cameraWidgetProps": null
        },
        "socketEvent": null
      },
    },
  },

];

describe("UserList", () => {
  afterEach(() => {
    cleanup();
  });

  it("renders without error", async () => {
    TestRenderer.create(
      <MockedProvider cache={cache} mocks={mocks} resolvers={resolvers} addTypename>
        <TestLogin/>
      </MockedProvider>,
    );

    await act(() => new Promise(resolve => setTimeout(resolve, 0)));

    await expect(screen.getByText("CRITICAL: System in a CRITICAL state.  See details for more information."));
  });
});
