/* eslint-disable import/no-extraneous-dependencies */
import React from "react";
import { Image } from "semantic-ui-react";
import PageWrapper from "components/PageWrapper";
import Login from "components/Login";
import { origin } from "core/api";
import { useStore } from "@core/store";

import "./style.css";

const LoginPage = () => {
  const { store: { branding } } = useStore();

  return (
    <PageWrapper showLanguageSelector>
      <div className="left-side">
        <Image src={`${origin}${branding?.LOGIN_BACKGROUND_PATH ?? ""}`} fluid/>
      </div>
      <div className="right-side">
        <Login/>
      </div>
    </PageWrapper>
  );
};

export default LoginPage;
