import { DragObjectWithType } from "react-dnd";
import { SemanticICONS } from "semantic-ui-react";
import { EventInfo, ViewId, WidgetId } from "@generated/graphql";
import { UUID } from "@solid/types";
import type Electron from "electron";

export enum DragObjectType {
  Camera = "camera",
  Event = "event"
}

export interface DragObject extends DragObjectWithType {
  obj: PlayerProps | (EventInfo & { entries?: EventInfo[] });
  sourceWidgetId?: string;
  cameraDisabled?: boolean;
}

export interface ObjProps {
  "data-id": UUID;
  name: string;
}

export interface PlayerProps extends ObjProps {
  time?: Date | null;
}

export function isDragObject(obj: any): obj is DragObject {
  return !!obj && !!(obj as DragObject).type;
}

export function isObject(obj: any): obj is ObjProps {
  return !!obj && !!(obj as ObjProps)["data-id"] && (obj as ObjProps).name !== undefined;
}

export function isEvent(obj: any): obj is EventInfo {
  return !!obj && !!(obj as EventInfo).entry;
}

export type ModuleInfo = {
  id: WidgetId | ViewId | string;
  name: string;
  module: string;
  props?: object;
  hasLayout?: boolean;
  widgets?: ModuleInfo[];
  isSystem?: boolean;
  isLocal?: boolean;
  isShared?: boolean;
  templateId?: string;
  layoutId?: string;
  layout?: ViewLayoutItem[];
  widgetId?: WidgetId;
  index?: number;
  inWindow?: boolean;
  displayId?: number;
  rect?: Electron.Rectangle;
  aspectRatio?: number;
  designDisplayId?: number;
  editMode?: boolean;
  ignoreAspectRatio?: boolean;
  hideCloseButton?: boolean;
  hideHeaderControls?: boolean;
  userId?: UUID;
  originalViewId?: string;
  hasUnsavedChanges?: boolean;
  isAdmin?: boolean;
  icon?: SemanticICONS;
  svgIcon?: string;
  hidden?: boolean;
};

export function isModuleInfo(value: any): value is ModuleInfo {
  return !!value && (value as ModuleInfo).id !== undefined && (value as ModuleInfo).name !== undefined && (value as ModuleInfo).module !== undefined;
}

export type ModuleWindowProps = Pick<ModuleInfo, "inWindow" | "displayId" | "rect">;

export enum ViewLayoutItemType { Split = "Split", Cell = "Cell" }
export enum ViewLayoutItemOrientation { Horizontal = "horizontal", Vertical = "vertical" }

export type ViewLayoutItem = {
  type: ViewLayoutItemType;
  orientation?: ViewLayoutItemOrientation;
  size: number;
  items?: ViewLayoutItem[];
};

export type RouteParams = {
  viewId?: string,
  linkId?: string,
  cameraId?: string,
  userId?: string,
  policyId?: string,
  groupId?: string,
  zoneId?: string,
  setId?: string,
  tabId?: string,
  sensorId?: string
  gatewayId?: string;
};
