import React from "react";
import { withStore, WithStoreProps } from "@core/store";
import "./style.css";

type ClassComponentProps = {
  someProp?: boolean
} & WithStoreProps;

class ClassComponent extends React.Component<ClassComponentProps> {
  override render() {
    const {isLoggedIn} = this.props.store.session;

    return (
      <div className="class-component">
        <div>ClassComponentWithStore</div>
        <div>isLoggedIn = {isLoggedIn ? "true" : "false"}</div>
      </div>
    );
  }
}

export default withStore(ClassComponent);
