import React from "react";
import { Message } from "semantic-ui-react";
import Loading from "components/Loading";
import {__} from "@solid/libs/i18n";

import "./style.css";

interface WithQueryStatusProps {
  loading?: boolean;
  error?: Error | null;
  noData?: boolean;
}

function WithQueryStatus({ loading, error, noData, children }: React.PropsWithChildren<WithQueryStatusProps>) {
  return (
    <>
      { loading && <div className="WithQueryStatus-LoadingRoot"><Loading/></div> }
      { !loading && !!error && <Message visible error header={__("Error")} content={error.message}/> }
      { !loading && !error && noData && <Message visible warning content={__("No data to display.")}/> }
      { !loading && !error && !noData && children }
    </>
  );
}

export default WithQueryStatus;
