import React, { useEffect } from "react";
import { ModuleInfo } from "@core/types";
import WidgetRender from "components/Widgets/WidgetRender";
import { Widgets, WidgetProps } from "components/Widgets";

type WidgetPreviewProps = WidgetProps & {
  module: ModuleInfo;
};

const WidgetPreview = (props: WidgetPreviewProps) => {
  const { module, ...widgetProps } = props;
  const widget = Widgets.find(w => w.id === module.widgetId) ?? Widgets.find(w => w.module === module.module);

  useEffect(() => {
    const { setCellProps } = props;
    if (setCellProps) {
      setCellProps({ hideHeader: !widget });
    }
  }, [widget]);

  return (
    <>
      { !!widget &&
      <WidgetRender component={widget.renderStub()} componentProps={module.props} widgetId={widget.id} {...widgetProps} /> }
    </>
  );
};

export default WidgetPreview;
