import React from "react";
import { ReactSVG } from "react-svg";
import { Icon } from "semantic-ui-react";

type VDMHeaderProps = {
  icon?: string;
  title?: React.ReactNode;
  onWindowClose: () => void;
};

const WidgetHeader = React.memo(({ icon, title, onWindowClose }: VDMHeaderProps) => {
  return (
    <div className="WidgetRender-Header">
      <ReactSVG role="small-icon" src={icon || ""}/>
      <div className="WidgetRender-Title">{title}</div>
      <Icon name="close" onClick={onWindowClose}/>
    </div>
  );
});

export default WidgetHeader;
