import React, { useRef, useEffect, useState } from "react";
import { Segment } from "semantic-ui-react";
import { ModuleInfo } from "@core/types";
import { useConfig, useLayout } from "@core/store/actions";
import { RBoxPanel, RWidgetLoader } from "components/Layout";

import "./style.css";

type ViewPreviewProps = {
  view: ModuleInfo;
  width: number;
  height: number;
};

const ViewPreview = ({ view, width, height }: ViewPreviewProps) => {
  const { views, allViews, layout } = useConfig();
  const mainPanelRef = useRef<RBoxPanel>(null);
  const viewLoaderRef = useRef<RWidgetLoader>(null);
  const { allViewsLayoutRef } = useLayout({ layout, views, allViews, mainPanelRef, viewLoaderRef, isLoaded: true });
  const [visible, setVisible] = useState(false);

  const rootId = `${view.id}_previewRoot`;
  const layoutId = `${view.id}_previewLayout`;

  useEffect(() => {
    setVisible(true);
  }, []);

  return (
    <Segment id={rootId} style={{ width: width + "px", height: height + "px" }} className="ViewPreview-Root">
      { visible &&
      <RBoxPanel id={layoutId} layoutElementId={layoutId} rootElementId={rootId} ref={mainPanelRef} direction="top-to-bottom"
        minWidth={width} maxWidth={width} minHeight={height} maxHeight={height} widgetClass="ViewPreview-LayoutRoot">
        <RWidgetLoader ref={viewLoaderRef} modules={[view]} layoutRef={allViewsLayoutRef} widgetClass="Widget-Content_noSizeLimits"
          showHeader ignoreFixedSizes hideCloseButton hideHeaderControls />
      </RBoxPanel> }
    </Segment>
  );
};

export default ViewPreview;
