import React from "react";
import { ViewManagerResult } from "components/View";
import { List } from "semantic-ui-react";
import {__} from "@solid/libs/i18n";
import ViewButton from "./ViewButton";

import "./style.css";

type UserViewListProps = {
  vm: ViewManagerResult;
  filter?: string;
};

const UserViewList = ({ vm, filter }: UserViewListProps) => {
  const { config: { allViews } } = vm;
  return (
    <div className="ViewList">
      <List className="ViewList-ButtonPanel">
        { allViews.filter(v => !v.isSystem && !v.isShared && (!filter || v.name.toLocaleUpperCase().includes(filter.toLocaleUpperCase())))
          .sort((a, b) => a.name.localeCompare(b.name, undefined, { sensitivity: "base" }))
          .map(view => <ViewButton key={view.id} view={view} vm={vm}/>) }
      </List>
    </div>
  );
};

export default UserViewList;
