import React, { Dispatch, SetStateAction } from "react";
import { Icon } from "semantic-ui-react";
import { UUID } from "@solid/types";
import { CameraObj } from "../VideoTouring";
import CameraListItem from "components/CameraList/CameraListItem";
import { SelectionStyle } from "components/CameraList";

import "./style.css";

type VideoTouringListProps = {
  cameraList: CameraObj[],
  deleteFromList: (id: UUID, index: number) => void,
  editMode: boolean,
  playingIndex?: number,
  setCurrentIndex?: Dispatch<SetStateAction<number | undefined>>
};

const VideoTouringList = ({cameraList, deleteFromList, editMode, playingIndex, setCurrentIndex}: VideoTouringListProps) => {
  return (
    <div className="ui segment CameraList-Root">
      {cameraList.map((camera, index) =>
        <div key={`${camera.obj["data-id"]}_${index}`} className="VideoTouringList-Item">
          <CameraListItem
            data-id={camera.obj.id}
            name={camera.obj.name}
            selected={playingIndex === index}
            selectable
            selectionStyle={SelectionStyle.Background}
            onClick={() => setCurrentIndex && setCurrentIndex(index)}
            disabled={camera.cameraDisabled}
            />
          {editMode && <Icon name="close" className="ViewHeader-CloseButton" onClick={() => deleteFromList(camera.obj.id, index)}/>}
        </div>
      )
      }
    </div>
  );
};

export default VideoTouringList;
