import React, { useEffect, useRef, useState } from "react";
import { Icon, Popup } from "semantic-ui-react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { useReactiveVar } from "@apollo/client";

import { __ } from "@solid/libs/i18n";
import useVideoDelivery from "@core/actions/videoDelivery";

import { StatusBarOpenComponentId } from "components/StatusBar";
import VideoDeliveryManager from "components/VideoDeliveryManager";

import "./style.css";

const VDMTrigger = () => {
  const [popupOpen, setPopupOpen] = useState(false);
  const [updatedRequests, setUpdatedRequest] = useState(false);
  const [updatedRequestsPopupOpen, setUpdatedRequestPopupOpen] = useState(false);
  const [waitRequest, setWaitRequest] = useState(false);
  const { userRequests } = useVideoDelivery({ waitRequest });
  const popupRef = useRef(null);

  const openComponentId = useReactiveVar(StatusBarOpenComponentId);
  const triggerId = "VDMTrigger";

  useEffect(() => {
    !waitRequest && setWaitRequest(true);

    return () => {
      setWaitRequest(false);
    };
  }, []);

  useEffect(() => {
    if (openComponentId && openComponentId !== triggerId) {
      setPopupOpen(false);
      setUpdatedRequest(false);
      setUpdatedRequestPopupOpen(false);
    }
  }, [openComponentId]);

  useEffect(() => {
    if (userRequests && userRequests?.length > 0 && !updatedRequests && !popupOpen) {
      setUpdatedRequest(true);
    }
  }, [userRequests]);

  useEffect(() => {
    if (userRequests && userRequests?.length > 0 && updatedRequests && !updatedRequestsPopupOpen && !popupOpen) {
      setUpdatedRequestPopupOpen(true);
    }
  }, [updatedRequests, popupOpen, userRequests]);

  function onHandleChange() {
    const openComponentId = popupOpen ? undefined : triggerId;
    StatusBarOpenComponentId(openComponentId);
    setPopupOpen(!popupOpen);
    setUpdatedRequest(false);
    setUpdatedRequestPopupOpen(false);
  }

  return (
    <>
      <Popup
        className="VDMTrigger-Popup"
        inverted
        flowing
        open={popupOpen}
        position="top right"
        content={<VideoDeliveryManager onWindowClose={onHandleChange}/>}
        key="VDMTrigger"
        context={popupRef}
      />
      {updatedRequests &&
      <Popup
        className="UpdatedRequestPopup"
        flowing
        open={updatedRequestsPopupOpen}
        context={popupRef}
        content={
          <div className="UpdatedRequestPopup-Notification">
            {__("You have the resolved download job")}
            <Icon name="close" className="CloseUpdatedRequestPopup-Icon" onClick={() => setUpdatedRequestPopupOpen(false)}/>
          </div>
        }
      />}

      <Popup
        flowing
        disabled={updatedRequestsPopupOpen || popupOpen}
        content={updatedRequests ? __("You have the resolved download job") : __("Video delivery manager")}
        trigger={
          <div className="VDMTrigger" ref={popupRef} onClick={onHandleChange} >
            <FontAwesomeIcon icon="cloud-download-alt" />
            {updatedRequests && <div className="VDMTrigger-Label" />}
          </div>
        }
      />
    </>
  );
};

export default VDMTrigger;
