import React from "react";
import { AutoSizer, Column, Table } from "react-virtualized";
import { Segment } from "semantic-ui-react";
import { AodRequest } from "@generated/graphql";
import { __ } from "@solid/libs/i18n";
import WithQueryStatus from "components/WithQueryStatus";
import VDMCellContent from "../VDMCellContent";

import "./style.css";

type VDMTableProps = {
  loading?: boolean,
  error?: Error,
  list: AodRequest[],
  onDownloadsOpen: (rowData: AodRequest) => void;
  updateRequests: (requests: AodRequest[]) => void;
};

const VDMRequestsTable = ({ loading, error, list, onDownloadsOpen, updateRequests }: VDMTableProps) => {
  return (
    <Segment className="VDMTable-Root">
      <WithQueryStatus loading={loading} error={error}>
        <div className="VDMTable-Grid">
          <AutoSizer style={{ width: "100%", height: "100%" }} className="VDMTable-AutoSizer">
            {({ width, height}) => (
              <Table
                className="VDMTable"
                width={width}
                height={height}
                headerHeight={50}
                rowHeight={35}
                rowCount={list.length}
                rowGetter={({ index }) => list[index]}
             >
                <Column
                  dataKey="id"
                  label={__("ID")}
                  width={75}
                  flexGrow={1}
                  cellRenderer={({ dataKey, rowData }) => <VDMCellContent dataKey={dataKey} request={rowData} />}
            />
                {/* <Column
                  dataKey="eventid"
                  label={__("Event ID")}
                  width={100}
                  flexGrow={1}
                  cellRenderer={({ dataKey, rowData }) => <VDMCellContent dataKey={dataKey} request={rowData} />}
            /> */}
                <Column
                  dataKey="deviceName"
                  label={__("Device Name")}
                  width={340}
                  flexGrow={1}
                  cellRenderer={({ dataKey, rowData }) => <VDMCellContent dataKey={dataKey} request={rowData} />}
            />
                <Column
                  dataKey="from"
                  label={__("From")}
                  width={220}
                  flexGrow={1}
                  cellRenderer={({ dataKey, rowData }) => <VDMCellContent dataKey={dataKey} request={rowData} />}
            />
                <Column
                  dataKey="duration"
                  label={__("Duration")}
                  width={100}
                  flexGrow={1}
                  cellRenderer={({ dataKey, rowData }) => <VDMCellContent dataKey={dataKey} request={rowData} />}
            />
                <Column
                  dataKey="status"
                  label={__("Status")}
                  width={200}
                  flexGrow={1}
                  cellRenderer={({ dataKey, rowData }) => <VDMCellContent dataKey={dataKey} request={rowData} />}
            />
                <Column
                  dataKey="action"
                  label={__("Action")}
                  width={100}
                  flexGrow={1}
                  cellRenderer={({ dataKey, rowData }) =>
                    <VDMCellContent
                      dataKey={dataKey}
                      request={rowData}
                      onDownloadsOpen={onDownloadsOpen}
                      updateRequests={updateRequests} />
                  }
            />
              </Table>
            )}
          </AutoSizer>
        </div>
      </WithQueryStatus>
    </Segment>
  );
};

export default VDMRequestsTable;
