import React, { useMemo } from "react";
import { Segment } from "semantic-ui-react";
import { AutoSizer, Column, Table } from "react-virtualized";
import { AodRequest, AodRequestFilesListEntry } from "@generated/graphql";
import { __ } from "@solid/libs";
import WithQueryStatus from "components/WithQueryStatus";
import VDMCellContent from "../VDMCellContent";

import "./style.css";

type VDMDownloadsProp = {
  rowData: AodRequest;
};

const VDMDownloadsTable = ({ rowData }: VDMDownloadsProp) => {
  const downloads: AodRequestFilesListEntry[] = useMemo(() => {
    const files = rowData?.files;
    if (files) {
      const { list } = files;
      return list;
    }
    return [];
  }, [rowData]);

  return (
    <Segment className="VDMTable-Root">
      <WithQueryStatus>
        <div className="VDMTable-Grid">
          {downloads && downloads.length > 0 &&
          <AutoSizer style={{ width: "100%", height: "100%" }} className="VDMTable-AutoSizer">
            {({ width, height}) => (
              <Table
                className="VDMTable"
                width={width}
                height={height}
                headerHeight={50}
                rowHeight={35}
                rowCount={downloads.length}
                rowGetter={({ index }) => downloads[index]}
                      >
                <Column
                  dataKey="from"
                  label={__("From")}
                  width={800}
                  flexGrow={1}
                  cellRenderer={({ dataKey, rowData }) => <VDMCellContent dataKey={dataKey} downloadFile={rowData} />}
                        />
                <Column
                  dataKey="duration"
                  label={__("Duration")}
                  width={100}
                  flexGrow={1}
                  cellRenderer={({ dataKey, rowData }) => <VDMCellContent dataKey={dataKey} downloadFile={rowData} />}
                        />
                <Column
                  dataKey="size"
                  label={__("Size")}
                  width={100}
                  cellRenderer={({ dataKey, rowData: downloadFile }) => <VDMCellContent dataKey={dataKey} downloadFile={downloadFile} request={rowData} />}
                  flexGrow={1}
                        />
              </Table>
            )}
          </AutoSizer>
          }
        </div>
      </WithQueryStatus>
    </Segment>
  );
};

export default VDMDownloadsTable;
