import React, { useMemo } from "react";
import { Button, Header, Icon } from "semantic-ui-react";
import { AodRequest, AodRequestFilesListEntry } from "@generated/graphql";
import { __ } from "@solid/libs";
import { formatExpirationTime, downloadAll } from "@core/actions/videoDelivery";

import "./style.css";

type VDMDownloadControlsProps = {
  onBack: () => void;
  rowData?: AodRequest;
};

const VDMDownloadControls = ({ onBack, rowData }: VDMDownloadControlsProps) => {
  const files = rowData?.files;
  const downloads: AodRequestFilesListEntry[] = useMemo(() => {
    if (files) {
      const { list } = files;
      return list;
    }
    return [];
  }, [rowData, files]);

  return (
    <div className="VDMDownLoadControls">
      <div className="VDMDownLoadControls-Buttons">
        <Button onClick={() => onBack()}>
          <Icon name="arrow left"/>{__("Back")}
        </Button>
        {downloads && rowData &&
          <Button onClick={() => downloadAll(downloads)}>
            <Icon name="cloud download" />{__("Download all")}
          </Button>}
      </div>
      <div className="VDMDownLoadControls-Title">
        <Header.Content className="VDMDownLoad-Header">
          {rowData?.expiredAt && formatExpirationTime(new Date(rowData.expiredAt))}
        </Header.Content>
      </div>
    </div>
  );
};

export default VDMDownloadControls;
