import React, { useState } from "react";
import { Icon, Popup } from "semantic-ui-react";
import { __ } from "@solid/libs";
import VDMConfirm from "components/VideoDeliveryManager/VDMConfirm";

import "./style.css";

type VDMContentControlsProp = {
  disabled: boolean;
  cancelAll: () => Promise<void>
};

const VDMContentControls = ({ disabled, cancelAll }: VDMContentControlsProp) => {
  const [cancelOpen, setCancelOpen] = useState<boolean>(false);

  return (
    <div className="VDMControls-Panel" >
      <Popup
        on="click"
        hideOnScroll
        position="top center"
        open={cancelOpen}
        onClose={(e: React.SyntheticEvent) => {
          e.preventDefault();
          setCancelOpen(false);
        }}
        content={
          <VDMConfirm
            title={__("Remove all request?")}
            confirmButtonText={__("Confirm")}
            onCancel={() => setCancelOpen(false)}
            onConfirm={() => {
              setCancelOpen(false);
              cancelAll();
            }}
          />
        }
        trigger={
          <Popup
            content={__("Remove all requests")}
            position="top center"
            disabled={cancelOpen}
            trigger={
              <div className="VDMControls-CancelAll">
                <Icon
                  name="trash"
                  disabled={disabled}
                  onClick={() => setCancelOpen(!cancelOpen)}
                />
              </div>
            }
          />
        }
      />
    </div>
  );
};

export default VDMContentControls;
