import { PlayerCommand, PlayerCommandArgs } from "@core/playerTypes";
import { WidgetEvent } from "components/Widgets";
import { DeviceWithState } from "./Timeline";

export const playerCommand = (widgetEvent: WidgetEvent, devices: DeviceWithState[], command: PlayerCommand, args?: Partial<PlayerCommandArgs>): void => {
  const eventArgs: PlayerCommandArgs = args ?? {};
  eventArgs.objs = devices.map(dev => dev.id);
  eventArgs.widgetIndices = devices.map(dev => dev.widgetIndex);
  if (command === PlayerCommand.Play && !args?.time) {
    const time = devices.reduce((accumulator, device) => Math.max(accumulator, device.timelineTime ?? 0), 0);
    if (time) {
      eventArgs.time = new Date(time);
    }
  }

  widgetEvent.publish({
    event: command,
    args: eventArgs
  });
};
