import React, { useRef } from "react";
import { Segment, Dimmer, Loader } from "semantic-ui-react";
import classNames from "classnames";
import { UUID } from "@solid/types";
import { useSnapshot } from "@core/actions";
import Loading from "components/Loading";
import { __ } from "@solid/libs";

import "./style.css";

type SnapshotProps = {
  snapshotId: UUID,
  load: boolean,
};

const Snapshot = ({ snapshotId, load }: SnapshotProps) => {
  const imageRef = useRef<HTMLImageElement>(null);
  const { imageSrc, loading, updating } = useSnapshot({ load, deviceId: snapshotId, imageRef });

  return (
    <Segment className="Snapshot-Wrapper">
      <Loading active={loading} className="Snapshot-Loading"/>
      <Dimmer active={updating} className="Snapshot-Updating">
        <Loader>{__("Updating...")}</Loader>
      </Dimmer>
      {!!imageSrc && <img ref={imageRef} src={imageSrc} alt="snapshot" className={classNames("Snapshot-Image", { "hidden": loading })}/>}
    </Segment>
  );
};

export default Snapshot;
