import classNames from "classnames";
import React, { useRef, useState } from "react";
import { Segment } from "semantic-ui-react";
import {origin} from "@core/api";

import "./style.css";

const NotificationPolicies = () => {
  const [loading, setLoading] = useState<boolean>(true);
  const iframeRef = useRef<HTMLIFrameElement>(null!);

  const onLoad = () => {
    if (!iframeRef.current.contentWindow) {
      console.error("!iframeRef.current.contentWindow");
      return;
    }

    const statusFlag = iframeRef.current.contentWindow.document.querySelector("#status-flag") as HTMLElement;
    if (statusFlag) {
      statusFlag.style.display = "none";
    }
    const solidUINotification = iframeRef.current.contentWindow.document.querySelector("#system-solid-ui-notification") as HTMLElement;
    if (solidUINotification) {
      solidUINotification.style.display = "none";
    }
    const menu = iframeRef.current.contentWindow.document.querySelector(".menu") as HTMLElement;
    if (menu) {
      menu.style.display = "none";
    }
    setLoading(false);

  };

  return (
    <Segment className={classNames("Notification-Policies-Root", { loading })}>
      <iframe
        id="NotificationPolicies"
        className="Notification-Policies"
        src={`${origin}/sdi/admin/#notificationPolicies`}
        frameBorder="0"
        title="NotificationPolicies"
        ref={iframeRef}
        onLoad={() => onLoad()}/>
    </Segment>
  );
};

export default NotificationPolicies;
