import React from "react";
import classNames from "classnames";
import { Loader, Dimmer } from "semantic-ui-react";
import {__} from "@solid/libs/i18n";

import "./style.css";

type LoadingLayout =
  "absolute vertical" |
  "relative vertical" |
  "relative horizontal" |
  "relative horizontal small";

type LoadingProps = {
  active?: boolean;
  text?: string;
  layout?: LoadingLayout;
  className?: string;
};

const Loading = ({ active = true, text, layout = "absolute vertical", className }: LoadingProps) => {
  const cls = classNames(
    { [className ?? ""]: !!className },
    { "Loading_relative": layout.includes("relative") },
    { "Loading_horizontal": layout.includes("horizontal") },
    { "Loading_vertical": layout.includes("vertical") },
    { "Loading_small": layout.includes("small") });
  return (
    <Dimmer active={active} className={cls}>
      <Loader>{text || __("Loading...")}</Loader>
    </Dimmer>
  );
};

export default Loading;
