import { Widget } from "@lumino/widgets";
import { RWidget } from "./RWidget";
import { RBoxPanel } from "./RBoxPanel";
import { RSplitPanel } from "./RSplitPanel";
import { RDockPanel } from "./RDockPanel";
import { RTabPanel } from "./RTabPanel";
import { RWidgetLoader } from "./RWidgetLoader";
import { RLayoutRender } from "./RLayoutRender";
import { ModuleInfo } from "@core/types";
import { EventPubSub } from "utils";
import { PanelSide } from "components/View/AddRowColPanel";

import "./style/index.css";
import "./style/lumino.less";

export type AddWidgetFunc = (dock: Widget, index?: number) => Widget;

export type WidgetCloseArgs = {
  id: string;
  name?: string;
};

export type LayoutChangedArgs = {
  id: string;
  layout: LayoutType;
};

export type CurrentChangedArgs = {
  index: number;
  id: string;
  prevIndex: number;
  prevId: string;
};

export type ModulesUpdateArgs = {
  modules: ModuleInfo[];
};

export type CanChangeToDisabledTabArgs = {
  id: string;
  index: number;
  prevId: string;
  prevIndex: number;
  canChange: boolean;
};

export type AddRowColArgs = {
  side: PanelSide;
};

export class AddRowColEvent extends EventPubSub<AddRowColArgs> {}

export type WidgetResizeArgs = {
  id: string;
  width: number;
  height: number;
};

export class WidgetResizeEvent extends EventPubSub<WidgetResizeArgs> {}

export type ViewArgs = {
  view: ModuleInfo;
  name?: string;
  displayId?: number;
};

export class ViewEvent extends EventPubSub<ViewArgs> {}

export type ViewIdArgs = {
  id: string;
};

export class ViewIdEvent extends EventPubSub<ViewIdArgs> {}

export type LayoutType = Record<string, any>;

export { RWidget, RBoxPanel, RSplitPanel, RDockPanel, RTabPanel, RWidgetLoader, RLayoutRender };
