import { SemanticICONS, DropdownItemProps } from "semantic-ui-react";
import { Label, LabelType } from "@generated/graphql";

export function getLabelIcon(label: Label): SemanticICONS {
  let iconName: SemanticICONS;
  switch (label.type) {
    case LabelType.Zone:
      iconName = "th large";
      break;
    case LabelType.Label:
      iconName = "tag";
      break;
    case LabelType.Set:
      iconName = "circle outline";
      break;
  }
  return iconName;
}

export function getLabelDropdownItem(label: Label): DropdownItemProps {
  return { key: label.id, value: label.id, text: label.name, icon: getLabelIcon(label) };
}
