import React, {Dispatch, SetStateAction, useEffect} from "react";
import { useMap } from "react-leaflet";
import leaflet, { LatLngTuple } from "leaflet";

type ResizeComponentProps = {
  latLngList: LatLngTuple[],
  layerWithBounds: React.MutableRefObject<leaflet.GeoJSON | null>
  reviewToMarkers: boolean
  setReviewToMarkers: Dispatch<SetStateAction<boolean>>
};

const ReviewCompoent = ({ latLngList, layerWithBounds, setReviewToMarkers, reviewToMarkers }: ResizeComponentProps) => {
  const map = useMap();

  useEffect(() => {
    if (latLngList.length === 0) {
      return;
    }

    if (layerWithBounds.current && reviewToMarkers) {
      layerWithBounds.current.addTo(map);

      if (latLngList.length === 1) {
        map.setView(layerWithBounds.current.getBounds().getCenter(), 15);
      } else {
        map.fitBounds(layerWithBounds.current.getBounds(), { animate: true, maxZoom: 15 });
      }
      setReviewToMarkers(false);
    }
  }, [latLngList, layerWithBounds]);

  return <></>;
};

export default ReviewCompoent;
