import React from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { IconProp } from "@fortawesome/fontawesome-svg-core";
import { ReactSVG } from "react-svg";
import { Popup, PopupProps } from "semantic-ui-react";
import classNames from "classnames";
import { PropType } from "utils";

import "./style.css";

type FontAwesomeButtonProps = {
  icon?: IconProp;
  svgIcon?: string;
  hint?: string;
  disabled?: boolean;
  hintPosition?: PopupPosition;
  onClick?: () => void;
};

type PopupPosition = PropType<PopupProps, "position">;

const FontAwesomeButton = ({ icon, svgIcon, hint, disabled = false, hintPosition, onClick }: FontAwesomeButtonProps) => {
  return (
    <Popup
      trigger={
        <div className={classNames("FontAwesomeButton", { disabled })} onClick={!disabled ? onClick : undefined}>
          {!!icon && <FontAwesomeIcon icon={icon}/>}
          {!!svgIcon && <ReactSVG role="small-icon" src={svgIcon}/>}
        </div>
      }
      content={hint}
      disabled={disabled || !hint}
      position={hintPosition}
    />
  );
};

export default FontAwesomeButton;
