import React, {useState, useEffect } from "react";
import { useNavigate } from "react-router-dom";
import { useLicenseAcceptedQuery } from "@generated/graphql";
import EulaPage from "./EulaPage";
import WithQueryStatus from "components/WithQueryStatus";

import { __ } from "@solid/libs/i18n";

enum EnumRequestState {
  IDLE,
  Success,
  Pending,
  Failed
}

const Eula = () => {
  const {data, loading, error} = useLicenseAcceptedQuery();
  const navigate = useNavigate();
  const [requestState, setRequestState] = useState<EnumRequestState>(EnumRequestState.IDLE);

  useEffect(() => {
    if (error) {
      setRequestState(EnumRequestState.Failed);
      return;
    }
    if (loading || !data) {
      setRequestState(EnumRequestState.Pending);
    }

    if (data?.license.isAccepted === true) {
      navigate("/selectrealm");
    }

    if (data?.license.isAccepted === false) {
      setRequestState(EnumRequestState.Success);
    }
  }, [data, loading, error]);

  const Content = {
    [EnumRequestState.Success]: () => <EulaPage/>,
    [EnumRequestState.IDLE]: () => null,
    [EnumRequestState.Pending]: () => <WithQueryStatus loading/>,
    [EnumRequestState.Failed]: () => (
      <WithQueryStatus error={error}/>
    )
  }[requestState];

  return (
    <>
      <Content/>
    </>

  );
};

export default Eula;
