import React, { useEffect, useState } from "react";
import {useNavigate, useParams} from "react-router-dom";
import { Form, Segment, Button, Header, List, Message } from "semantic-ui-react";
import { useLoginDone } from "@core/store/actions";
import { verify } from "core/api";
import {__} from "@solid/libs/i18n";

import "./styles.css";

const ConfirmCode = () => {
  const { secret = ""} = useParams<{secret: string}>();
  const [confirmCode, setConfirmCode] = useState(secret);
  const [isConfirmCode, setIsConfirmCode] = useState(false);
  const [errorMessage, setErrorMessage] = useState("");

  const navigate = useNavigate();

  const { loginDone } = useLoginDone();

  const confirm = async () => {
    try  {
      setErrorMessage("");
      await verify(confirmCode);
      await loginDone();
      navigate("/");
    }
    catch (error: any) {
      if (error.code === 600) {
        navigate("/passwordexpired");
      } else {
        setErrorMessage(error.message);
      }
    }
  };

  useEffect(() => {
    if (confirmCode.length > 0) {
      setIsConfirmCode(true);
    }
  }, [confirmCode]);

  return (
    <Segment className="Confirm-Code">
      <Form onSubmit={e => e.preventDefault()}>
        <Form.Field>
          <Header as="h1" className="Confirm-Code-Header">{__("Complete Login")}</Header>
          <Message visible error content={errorMessage} hidden={!errorMessage} />
        </Form.Field>
        <div className="form-text">
          <List>
            <List.Item>
              <List.Content>
                <List.Description>
                  {__("Please enter the verification code we just sent to your email address")}
                </List.Description>
              </List.Content>
            </List.Item>
          </List>
        </div>
        <Form.Field>
          <input
            type="text"
            id="confirmCode"
            tabIndex={1}
            placeholder={__("Verify code")}
            autoFocus
            defaultValue={confirmCode}
            onInput={(e) => { setConfirmCode(e.currentTarget.value); }}
            required
          />
        </Form.Field>
        <Button
          id="confirm"
          disabled={!isConfirmCode}
          primary
          fluid
          onClick={() => confirm()}
        >
          {__("Confirm")}
        </Button>
      </Form>
    </Segment>
  );
};

export default ConfirmCode;
