import React from "react";
import AutoForm, { AutoFormContext, FieldSchema } from "../AutoForm";
import StringField from "../StringField";
import IntegerField from "../IntegerField";
import FloatField from "../FloatField";
import DropdownField from "../DropdownField";
import CheckboxField from "../CheckboxField";
import PasswordField from "../PasswordField";
import ButtonField from "../ButtonField";

type AutoFieldProps = {
  name: string;
};

type AutoFieldState = {
  field?: FieldSchema;
};

class AutoField extends React.Component<AutoFieldProps, AutoFieldState> {
  static override contextType = AutoFormContext;
  private id = `${Date.now()}.${Math.random()}`;
  private form?: AutoForm;

  constructor(props: AutoFieldProps) {
    super(props);
    this.state = {};
  }

  override componentDidMount(): void {
    this.form = this.context?.form;
    this.form?.registerObserver(this.id, schema => this.setState({ field: schema.find(field => field?.name === this.props.name) }));
  }

  override componentWillUnmount(): void {
    this.form?.unregisterObserver(this.id);
  }

  override render() {
    const { name } = this.props;
    const { field } = this.state;
    if (!field) {
      return null;
    }

    const type = field.type ?? "string";
    switch (type) {
      case "string": return <StringField name={name}/>;
      case "integer": return <IntegerField name={name}/>;
      case "float": return <FloatField name={name}/>;
      case "dropdown": return <DropdownField name={name}/>;
      case "checkbox": return <CheckboxField name={name}/>;
      case "password": return <PasswordField name={name}/>;
      case "button": return <ButtonField name={name}/>;
      default: return null;
    }
  }
}

export default AutoField;
