import React, { FC } from "react";
import { Icon } from "semantic-ui-react";
import "./style.css";

interface CameraListProps {
  cameras: string[];
}

export const CameraList: FC<CameraListProps> = ({ cameras }) => {
  return (
    <div className="DeviceCameraList">
      {cameras.length !== 0 ? (
        <div>
          <Icon name="video camera" />
          <span>{cameras.length}</span>
        </div>
      ) : (
        <span>No assigned cameras</span>
      )}
    </div>
  );
};
