import React, { FC } from "react";
import { Header, Icon, Popup, Segment } from "semantic-ui-react";
import { __ } from "@solid/libs";
import EntityTable, { EntityTableProps } from "components/EntityTable";
import { Device } from "./AssignCamera";

interface AssignedCamerasProps {
  cameras: Device[];
  deviceName: string;
  removeCamera: (camera: Device) => void;
}

export const AssignedCameras: FC<AssignedCamerasProps> = ({ deviceName, cameras, removeCamera }) => {
  const assignedCamerasTableProps: EntityTableProps = {
    columns: ["", "Description"],
    widths: [undefined, 16],
    emptyLine: __("No assigned cameras"),
    rows: cameras?.reduce((acc, camera, index) => {
      acc.push([
        <Popup trigger={<Icon name="remove" onClick={() => removeCamera(camera)} />} content={__("Remove camera from device")} />,
        <span>&nbsp;{camera.name}</span>,
      ]);
      return acc;
    }, [] as React.ReactNode[][]),
  };
  return (
    <Segment className="CameraToAssign-Controls">
      <Header as="h5">{__(`Device name: ${deviceName}`)}</Header>
      <EntityTable {...assignedCamerasTableProps} />
    </Segment>
  );
};
