import React from "react";
import { Icon, Popup } from "semantic-ui-react";
import { __ } from "@solid/libs";
import { GatewayShort } from "@core/actions";

type TableActionsProps = {
  onSelect: (device: GatewayShort) => void;
  onDelete: (device: GatewayShort) => void;
  gateway: GatewayShort;
};

export const TableActions = React.memo(({ onSelect, onDelete, gateway }: TableActionsProps) => {
  return (
    <>
      <Popup
        trigger={
          <Icon
            name="edit"
            className="GatewayActions-IconButton"
            onClick={(e: React.MouseEvent) => {
              e.stopPropagation();
              onSelect(gateway);
            }}
          />
        }
        content={__("Configure")}
      />
      <Popup
        trigger={
          <Icon
            name="trash alternate"
            className="GatewayActions-IconButton"
            onClick={(e: React.MouseEvent) => {
              e.stopPropagation();
              onDelete(gateway);
            }}
          />
        }
        content={__("Delete")}
      />
    </>
  );
});
