import React from "react";
import { DeviceShort } from "@core/actions";
import { __ } from "@solid/libs";
import { Popup } from "semantic-ui-react";
import DeviceInfoTrigger from "components/Admin/AdminLinkList/DeviceInfoTrigger/DeviceInfoTrigger";
import DeviceInfoText from "components/Admin/AdminLinkList/DeviceInfoText";
import { HealthStatus } from "@generated/graphql";

type GatewayDevicesInfoType = {
  device: { total: number; countByStatus: Record<HealthStatus, number> };
  total: number;
};

export const DevicesInfoContent = ({ rowData }: { rowData: DeviceShort }) => {
  function getGatewayDevicesCounts(rowData: any): GatewayDevicesInfoType {
    return {
      device: {
        total: 10,
        countByStatus: {
          BROKEN: 0,
          DEGRADED: 0,
          NORMAL: 10,
          OFF: 0,
          PENDING: 0,
        },
      },
      total: 10,
    };
  }

  const { device, total } = getGatewayDevicesCounts(rowData);

  if (total === 0) {
    return <span className="AdminLinkList-DeviceInfo">{__("No devices registered")}</span>;
  }
  return (
    <Popup
      trigger={
        <div className="AdminLinkList-DeviceInfoWrapper">
          {device.total > 0 && <DeviceInfoTrigger countByStatus={device.countByStatus} total={device.total} icon="video" />}
        </div>
      }
    >
      <b>
        {__("Total")} - {total}
      </b>
      {device.total > 0 && <DeviceInfoText countByStatus={device.countByStatus} title={__("Cameras")} />}
    </Popup>
  );
};
