import React from "react";
import { CameraLog } from "@generated/graphql";
import { formatDateTime } from "@core/utils";

import "./style.css";

type CameraLogCellProps = {
  rowData: CameraLog;
  logKey: keyof CameraLog;
};

const CameraLogCell = ({ rowData, logKey }: CameraLogCellProps) => {
  return (
    <div className="CameraLogCell">
      <p className="CameraLogCell-Content">{ logKey === "time" ? formatDateTime(new Date(rowData[logKey])) : rowData[logKey] }</p>
    </div>
  );
};

export default CameraLogCell;
