import React from "react";

import { VaeUpdate } from "@generated/graphql";
import { __ } from "@solid/libs";

import VaeUpdateLog from "./VaeUpdateLog";
import EntityTable, { EntityTableProps } from "components/EntityTable";

type VaeUpdatesProps = {
  vaeUpdates: VaeUpdate[]
};

const VaeUpdates = ({ vaeUpdates }: VaeUpdatesProps) => {
  const vaeUpdatesTableProps: EntityTableProps = {
    columns: [__("Name"), __("Status"), __("Version"), __("Log")],
    rows: vaeUpdates.reduce<React.ReactNode[][]>((acc, vaeUpdate, index) => {
      acc.push([
        vaeUpdate.name,
        vaeUpdate.status,
        vaeUpdate.version || __("N/A"),
        <VaeUpdateLog vaeUpdate={vaeUpdate} key={`${vaeUpdate.name}_${index}`} />
      ]);
      return acc;
    }, [])
  };

  return (
    <EntityTable {...vaeUpdatesTableProps} />
  );
};

export default VaeUpdates;
