import ConfigureLink, {ConfigureLinkProps} from "./ConfigureLink";
import React, {useEffect, useState} from "react";
import {Device} from "@core/actions";
import {UUID} from "@solid/types";
import {useDeviceQuery} from "@generated/graphql";
import WithQueryStatus from "components/WithQueryStatus";

type ConfigureLinkWrapperProps = {
  deviceId: UUID
} & Omit<ConfigureLinkProps, "link">;

const ConfigureLinkWrapper = (props: ConfigureLinkWrapperProps) => {
  const [link, setLink] = useState<Device | null>(null);
  const {data: devicesData, error: devicesError, loading: devicesLoading} = useDeviceQuery({variables: {id: props.deviceId}});

  useEffect(() => {
    if (devicesData?.device) {
      const device = devicesData.device;
      setLink(device);
    }
  }, [devicesData]);

  return (
    <WithQueryStatus loading={devicesLoading} error={devicesError}>
      {link && <ConfigureLink link={link} {...props}/>}
    </WithQueryStatus>
  );
};

export default ConfigureLinkWrapper;
