import React from "react";

type SideBarProps = {
  showHeader?: boolean,
  children?: React.ReactElement,
  showSideBar: (visible: boolean) => void
};

const SideBar = (props: SideBarProps) => {
  const {showSideBar} = props;
  const {showHeader = false} = props;

  return (
    <div className="sidebar">
      {showHeader &&
        <div className="sidebar-header">
          <i className="close icon sidebar-close-btn" onClick={() => showSideBar(false)} />
        </div>
      }
      {props.children}
    </div>
  );
};

export default SideBar;
