import React from "react";
import classNames from "classnames";
import ActivityItem, {ActivityItemProps} from "components/Activity/ActivityItem";

type ActivityBarProps = {
  current: number;
  onChange: (index: number) => void;
  children?: React.ReactElement<ActivityItemProps, typeof ActivityItem>[];
  inactive?: boolean;
};

const ActivityBar = (props: ActivityBarProps) => (
  <div className="activity-bar">
    {React.Children.map(props.children, (child, index) => {
      if (!React.isValidElement<ActivityItemProps>(child)) return undefined;

      return (
        <>
          {child.key === "Separator" ?
            <div className="activity-item-tuple"/> :
            <div
              className={
                classNames("activity-item", {
                  "current": props.current === index,
                  "disabled": child.props.disabled,
                  "inactive": props.inactive
                }, child.props.name)
              }
              onClick={() => {
                if (!child.props.disabled) {
                  props.onChange(index);
                }
              }}>
              <div className="activity-icon">{child.props.icon}</div>
              <div className={`activity-name ActivityBar__${child.props.name}`}>{child.props.name}</div>
            </div>}
        </>);
    })}
  </div>);

export default ActivityBar;
