import { parsePluginOptions } from "@libs/fuse-box/plugins/pluginUtils";
import { Context } from "@libs/fuse-box/core/context";

export interface IPluginProps {
  useDefault?: boolean;
}

export function pluginGraphQL(a: string | RegExp | IPluginProps, b?: IPluginProps) {
  const [/*opts*/, matcher] = parsePluginOptions<IPluginProps>(a, b, {
    useDefault: true
  });
  return (ctx: Context) => {
    ctx.ict?.on("module_init", props => {
      const module = props?.module;

      if (!module || !matcher.test(module.absPath ?? "")) {
        return props;
      }
      module.read && module.read();
      module.contents = `
        Object.defineProperty(exports, "__esModule", { value: true });
        const gql = require("graphql-tag");
        module.exports.default = gql\`${module.contents}\`;`;
      return props;
    });
  };
}
