import Inspector from "./inspector";

export enum WorkerCommand {
  Inspect = 0,
  Print = 1,
  InspectAndPrint = 2
}

const inspector = new Inspector();

process.on("message", async (msg: any) => {
  switch (msg.type) {
    case WorkerCommand.Inspect:
      await inspector.inspect(msg.options);
      break;

    case WorkerCommand.Print:
      await inspector.print(msg.options);
      break;

    case WorkerCommand.InspectAndPrint:
      await inspector.inspect(msg.options);
      await inspector.print(msg.options);
      break;
  }
});
