## Electron

### Create ".pfx"

#### Extract the private key from ".pfx"

```
openssl pkcs12 -in certificate.pfx -nocerts -nodes -out key.pem
```

#### Convert the private key from ".pem" to ".pvk"
```
openssl rsa -in key.pem -outform PVK -pvk-strong -out key.pvk
```

#### Create ".pfx" from ".pvk" + ".spc"
pvk2pfx.exe from Windows SDK

path ex: "c:\Program Files (x86)\Windows Kits\8.1\bin\x86\pvk2pfx.exe"
```
pvk2pfx.exe -pvk key.pvk -pi <passphrase> -spc vn.spc -pfx certificate.pfx -po <passphrase> -f
```

### Sign

#### Manual sign
signtool.exe from Windows SDK

path ex: "c:\Program Files (x86)\Windows Kits\8.1\bin\x86\signtool.exe"
```
signtool sign /f vn.pfx /p <passphrase> /t http://timestamp.verisign.com/scripts/timestamp.dll some.msi
```

#### Sign with build

create
- packages/client/sign/certificate.pfx - certificate
- packages/client/pass.txt - password for certificate

## Build

### Env variables
Create packages/client/.env and specify next env variables:
- API_BACKEND - cluster url to connect
- API_MINIDUMP - sentry minidump upload url for player (get from sentry project settings)

Example:
```dotenv
API_BACKEND=https://test1.vsaas.videonext.net
API_SENTRY=https://o489711.ingest.sentry.io/api/5587932/minidump/?sentry_key=906c45cfd6374c0c88a80244b1c705b7
```

### Windows
build installer
```shell
yarn build:full:installer-win
```

### Mac
build installer
```shell
yarn build:full:installer-mac
```
