export type TimeLineDataList = {
  [timestamp in TimeStamp]: CoverageItem & {
    percentage?: number,
    className: string,
    color?: number,
    borderColor?: number,
    gradient?: string,
    inArchive?: boolean,
    eventCount?: number
  }
};

export type TimeLineData = {
  list: TimeLineDataList,
  isEvent?: boolean,
  granularity: Granularity,
  color?: number,
  borderColor?: number
};

export enum Granularity {
  second = "second",
  chunk = "chunk",
  min = "min",
  hour = "hour",
  day = "day",
  mon = "mon",
  year = "year"
}

export type CoverageItem = {
  isChunk?: boolean,
  isPartialChunk?: boolean,
  isAOD?: boolean,
  isEvent?: boolean,
  isSelected?: boolean,
  isOffline?: boolean
}

export type CoverageStream = {
  [time in TimeStamp]: CoverageItem
}

export type TimeStamp = number;

export type StreamObjectList<T> = {
  [stream: number]: T
}

export const CHUNK_SIZE = 30 * 1000; // ms
