/*
const console =  ((console) => {
  let isStore = false;
  let size = 100;
  const list = {
    log: [],
    info: [],
    warn: [],
    error: [],
    full: []
  };

  const add = (...args) => {
    list.full.push(args);
  };

  return {
    log: (...args) => {
      isStore && list.log.push(args);
      args.unshift("!!!");
      console.log.apply(null, args);
    },
    info: (...args) => {
      isStore && list.info.push(args);
      console.info.apply(null, args);
    },
    warn: (...args) => {
      isStore && list.warn.push(args);
      console.warn.apply(null, args);
    },
    error: (...args) => {
      isStore && list.error.push(args);
      console.error.apply(null, args);
    }
  };
})(window.console);
*/

type LoggerParameters = {
  isStore?: boolean,
  maxLength?: number,
  doubleToConsole?: boolean
}

type LoggerConsoleRow = {
  type: "log" | "info" | "warn" | "error",
  time: number, data: any[]
}

interface LoggerConsole extends Console {
  getLog(): LoggerConsoleRow[]
}

export class Logger implements LoggerConsole {
  Console!: console.ConsoleConstructor;

  isStore:boolean;
  list: LoggerConsoleRow[] = [];
  maxLength: number;
  doubleToConsole: boolean;

  constructor (parameters?: LoggerParameters) {
    this.isStore = parameters?.isStore ?? true;
    this.maxLength = parameters?.maxLength ?? 200;
    this.doubleToConsole = parameters?.doubleToConsole ?? false;
  }

  log(...args: any[]) {
    if (this.isStore) {
      this.list.push({type: "log", time: Date.now(), data: args});
      if (this.list.length > this.maxLength) {
        this.list.shift();
      }
    }
    this.doubleToConsole && console.log.apply(null, args);
  }

  info(...args: any[]) {
    if (this.isStore) {
      this.list.push({type: "info", time: Date.now(), data: args});
      if (this.list.length > this.maxLength) {
        this.list.shift();
      }
    }
    this.doubleToConsole && console.info.apply(null, args);
  }

  warn(...args: any[]) {
    if (this.isStore) {
      this.list.push({type: "warn", time: Date.now(), data: args});
      if (this.list.length > this.maxLength) {
        this.list.shift();
      }
    }
    this.doubleToConsole && console.warn.apply(null, args);
  }

  error(...args: any[]) {
    if (this.isStore) {
      this.list.push({type: "error", time: Date.now(), data: args});
      if (this.list.length > this.maxLength) {
        this.list.shift();
      }
    }
    this.doubleToConsole && console.error.apply(null, args);
  }

  getLog() {
    return this.list;
  }

  assert(condition?: boolean, ...data: any[]) {};
  clear() {}
  count(label?: string) {}
  countReset(label?: string) {}
  debug(...data: any[]) {}
  dir(item?: any, options?: any) {}
  dirxml(...data: any[]) {}
  group(...data: any[]) {}
  groupCollapsed(...data: any[]) {}
  groupEnd() {}
  profile(label?: string) {}
  profileEnd(label?: string) {}
  table(tabularData?: any, properties?: string[]) {}
  time(label?: string) {}
  timeEnd(label?: string) {}
  timeLog(label?: string, ...data: any[]) {}
  timeStamp(label?: string) {}
  trace(...data: any[]) {}
}
