export class Events {
  _topics: { [topic: string]: Function[] } = {};

  on(topic: string, listener: Function): number {
    if (!this._topics[topic]) this._topics[topic] = [];

    return this._topics[topic].push(listener) - 1;
  }

  once(topic: string, listener: Function): void {
    let index = this.on(topic, (data: any) => {
      this.removeListener(topic, index);
      listener(data);
    });
  }

  removeListener(topic: string, index: number): void {
    if (!this._topics[topic] || this._topics[topic].length < 1) return;

    delete this._topics[topic][index];
  }

  removeAllListeners(topic?: string): void {
    if (topic && this._topics[topic]) {
      delete this._topics[topic];
    } else {
      this._topics = {};
    }
  }

  trigger(topic: string, ...data: any) {
    if (!this._topics[topic] || this._topics[topic].length < 1) return;

    this._topics[topic].forEach((listener) => {
      try {
        listener(...data || {});
      }
      catch (e) {
        console.error(e);
      }
    });
  }
}
