import m from "mithril";
import {Log} from "../log";
import {API} from "../api";
import {AODModel} from "./aodmodel";
import {Obj, UUID} from "@solid/types";
import {AjaxError} from "../utils";

type AODListAttributes = {}
type AODListState = {}

export const AODList = (): m.Component<AODListAttributes, AODListState> => {
  let model: AODModel | null = null;
  let obj: UUID | null = null;
  let objectList: Obj[] = [];

  function init(obj: UUID) {
    let now = Math.round(Date.now() / 1000);
    let start = now - 60 * 60;
    let end = now;
    const model = new AODModel();
    model.init({objid: obj, startTs: start, endTs: end}, (list) => m.redraw());

    model.wait()
      .then(() => {
        console.log("DONE")
      })
      .catch(function (e: any) {
        if (e instanceof AjaxError) {
          Log.error(e.message);
        } else {
          throw e;
        }
      });
    m.redraw();
  }

  function getCameraList(): Promise<Obj[]> {
    return new Promise(function (resolve, reject) {
      let api = new API();
      api.getObjectList({
        type: "camera",
        withAttributes: true
      })
        .then(function (response) {
          let list = response.list.filter(function (row: Obj) {
            return row.attributes.STATUS === "ON";
          });
          resolve(list);
        })
        .catch(function (e) {
          Log.error(e.message);
        })
    });
  }

  function add(obj: UUID) {
    let now = Math.round(Date.now() / 1000);

    model?.submit(obj, now - 5 * 60, now - 4.5 * 60);
  }

  return {
    oninit: function ({state}) {
      getCameraList()
        .then((list) => {
          obj = list[0].obj;
          objectList = list;

          init(obj);
        });
    },
    view: function ({state}) {
      return [
        m("select", {
          selected: obj,
          onchange: (e: Event) => {obj = (e.target as HTMLSelectElement)?.value; init(obj)}
        }, objectList.map((row) => {return m("option", {value: row.obj}, `${row.obj} ${row.name}`)})),
        m("button", {onclick: () => obj && add(obj)}, "Start"),
        m("table", model?.list.map(function (row) {
          return m("tr", [
            m("td", row.requestid),
            m("td", row.createdTs, row.createdTs && String(new Date(row.createdTs))),
            m("td", row.completedTs, row.completedTs && String(new Date(row.completedTs))),
            m("td", row.status)
          ]);
        }))
      ];
    }
  }
};
