import type { API } from "@solid/libs";
import { UUID } from "@solid/types";

export class Auth {
  static password = "";
  static user = {obj: null, name: ""};
  static role = {obj: null, name: ""};
  static realm = {obj: null, name: ""};
  static status = "";
  static redirect = "";
  static api: API | null = null;

  static setAPI(api: API) {
    Auth.api = api;
  }

  static login({username, password, realmid = undefined}: {username: string, password: string, realmid?: UUID}): Promise<{info: any, status: any}> {
    return new Promise((resolve, reject) => {
      if (username && password) {
        Auth.user.name = username;
        Auth.password = password;
      } else {
        reject({message: "Specify login and password"});
        return;
      }

      const data: {credentials?: string, name: string, password?: string, realmid?: UUID} = {
        name: Auth.user.name,
        password: password
      };

      if (realmid) {
        data.realmid = realmid;
      }

      /*
      let url = window.location.href;
      let match = url.match(/^[^?]+([?]*.*)$/);
      if (match[1]) {
        let _options = m.parseQueryString(match[1]);
        if (_options.redirect) {
          data.redirect = _options.redirect;
        }
      }
      */

      Auth.api?.login(data)
        .then((response) => {
          Auth.user = Object.assign({}, response.info.user);
          Auth.role = Object.assign({}, response.info.role);
          Auth.realm = Object.assign({}, response.info.realm);
          Auth.status = response.status;
          Auth.redirect = response.redirect;

          resolve({info: response.info, status: response.status});
        })
        .catch((e) => {
          reject(e);
        })
    });
  }

  static logout() {
    return Auth.api?.logout();
  }
}
