export type Maybe<T> = T | null;
export type InputMaybe<T> = Maybe<T>;
export type Exact<T extends { [key: string]: unknown }> = { [K in keyof T]: T[K] };
export type MakeOptional<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]?: Maybe<T[SubKey]> };
export type MakeMaybe<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]: Maybe<T[SubKey]> };
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: string;
  String: string;
  Boolean: boolean;
  Int: number;
  Float: number;
  DateTime: Date;
  JSON: any;
  JSONObject: any;
};

export type AccessLevel = {
  __typename?: 'AccessLevel';
  description: Scalars['String'];
  level: Scalars['String'];
  order: Scalars['Int'];
};

/** Entry for multiple acknowledge */
export type AcknowledgementEntry = {
  context: Scalars['ID'];
  triggeredAt: Scalars['DateTime'];
};

export type Action = {
  __typename?: 'Action';
  accessLevel: AccessLevel;
  action: Scalars['String'];
  description: Scalars['String'];
  deviceFunctionalAspectTypes: Array<DeviceFunctionalAspectType>;
  resourceTypes: Array<RealmObjectType>;
};

export enum ActivityId {
  About = 'About',
  Access = 'Access',
  Devices = 'Devices',
  Settings = 'Settings'
}

export type AodRequest = {
  __typename?: 'AodRequest';
  avatarId: Scalars['ID'];
  completedAt?: Maybe<Scalars['DateTime']>;
  createdAt: Scalars['DateTime'];
  deviceId: Scalars['ID'];
  downloaded?: Maybe<Scalars['Int']>;
  endTime: Scalars['DateTime'];
  eta?: Maybe<Scalars['Int']>;
  eventId?: Maybe<Scalars['ID']>;
  expiredAt?: Maybe<Scalars['DateTime']>;
  files?: Maybe<AodRequestFiles>;
  id: Scalars['ID'];
  note?: Maybe<Scalars['String']>;
  realmId: Scalars['ID'];
  size?: Maybe<Scalars['Int']>;
  startTime: Scalars['DateTime'];
  status: AodRequestStatus;
  streamNumber: Scalars['Int'];
  type?: Maybe<AodRequestType>;
  updatedAt?: Maybe<Scalars['DateTime']>;
  userId: Scalars['ID'];
};

export type AodRequestFiles = {
  __typename?: 'AodRequestFiles';
  expired: Scalars['DateTime'];
  list: Array<AodRequestFilesListEntry>;
};

export type AodRequestFilesListEntry = {
  __typename?: 'AodRequestFilesListEntry';
  endTime: Scalars['DateTime'];
  href: Scalars['String'];
  size: Scalars['Int'];
  startTime: Scalars['DateTime'];
};

export type AodRequestFilter = {
  /**  time interval in hours from the current one for which you need to receive updates  */
  interval: Scalars['Int'];
};

export type AodRequestInput = {
  endTime: Scalars['DateTime'];
  isPrivate?: InputMaybe<Scalars['Boolean']>;
  obj: Scalars['ID'];
  startTime: Scalars['DateTime'];
};

export enum AodRequestStatus {
  Canceled = 'CANCELED',
  Completed = 'COMPLETED',
  Exporting = 'EXPORTING',
  Failed = 'FAILED',
  Paused = 'PAUSED',
  Processing = 'PROCESSING',
  Queued = 'QUEUED'
}

export enum AodRequestType {
  Auto = 'Auto',
  Manual = 'Manual'
}

export type ArchiveBoundary = {
  __typename?: 'ArchiveBoundary';
  boundary?: Maybe<Scalars['DateTime']>;
  timeInsideGap: Scalars['Boolean'];
};

export type ArchiveCoverage = {
  __typename?: 'ArchiveCoverage';
  coverage: Array<ArchiveCoverageItem>;
  partialCoverage: Array<ArchiveCoverageItem>;
  ttl: Array<ArchiveCoverageTtl>;
};

export type ArchiveCoverageItem = {
  __typename?: 'ArchiveCoverageItem';
  deviceId: Scalars['ID'];
  streamNumber: Scalars['Int'];
  time: Scalars['Int'];
};

export type ArchiveCoverageTtl = {
  __typename?: 'ArchiveCoverageTTL';
  deviceId: Scalars['ID'];
  ttl: Scalars['Int'];
};

/** Aspect Health settings and status */
export type AspectHealth = {
  __typename?: 'AspectHealth';
  /** importance of the aspect for the device health (CRITICAL/NORMAL/...) */
  gravity: Fa_HealthGravity;
  /** Status can take values from HealthStatus enum (from "core") */
  healthStatus: HealthStatus;
  /** timeout (seconds) before declaring aspect unhealthy */
  livenessTimeout: Scalars['Int'];
  /** timeout (seconds) after start before aspect is expected to perform normally */
  readinessTimeout: Scalars['Int'];
};

/** Aspect Health settings and status */
export type AspectHealthFilter = {
  /** importance of the aspect for the device health (CRITICAL/NORMAL/...) */
  gravity?: InputMaybe<Fa_HealthGravity>;
  /** Status can take values from HealthStatus enum (from "core") */
  healthStatus?: InputMaybe<HealthStatus>;
};

export enum AspectSensorCategory {
  Door = 'Door',
  Fence = 'Fence',
  None = 'None'
}

export enum AspectSensorModel {
  Generic = 'Generic',
  Hikvision = 'Hikvision'
}

export type AssociatedGatewayDevice = {
  __typename?: 'AssociatedGatewayDevice';
  /**  List of Overcast devices mapped to gateway device id  */
  associatedDevices: Array<Scalars['String']>;
  /**  Gateway device id  */
  id: Scalars['ID'];
  name: Scalars['String'];
};

export type AssociatedGatewayDeviceInput = {
  associatedDevices: Array<Scalars['String']>;
  id: Scalars['ID'];
};

/**
 * Audit entries are organized by Categories.
 * This is done in the way where the particular audit message is not reported by the actual message, but by numeric category.
 * One category entry may contain the parameterized message for multiple local languages in 'digest' attribute
 */
export type AuditCategory = {
  __typename?: 'AuditCategory';
  /**  JSON stored in a string, encoding parametrized messages for various localities, i.e. '{"en-us": "%1 stream request"}'  */
  digest: Scalars['String'];
  /**  Numeric ID in underlying implementation  */
  id: Scalars['ID'];
  /**  categories grouped by scope, parent is NULL for the first level category that cannot have events   */
  parent?: Maybe<Scalars['ID']>;
  /**  Field contains the info for generic identification  */
  shortName: Scalars['String'];
};

/** Audit entry provides the information for one audit event */
export type AuditEntry = {
  __typename?: 'AuditEntry';
  /**  The reference to the AuditCategory applicable to this particular entry  */
  category: AuditCategory;
  /**  Unique identifier for the Audit Event, uses UUIDv1 with timestamp part always equal to triggeredAt(!)  */
  context: Scalars['ID'];
  isAcknowledged: Scalars['Boolean'];
  /**  The audit message, which is properly applies parameters (like client language settings and event parameters) into the audit category message template  */
  message: Scalars['String'];
  /**  Audit Entry may contain zero or more metadata classifiers attached, these contain the normalized metadata categories and can be used for grouping/searching  */
  metadata: Array<MetaEntry>;
  /**  Date/Time when event was last updated, matches to triggeredAt for events never updated  */
  modifiedAt: Scalars['DateTime'];
  note?: Maybe<Scalars['String']>;
  /** Audit Entry may contain one or more attached snapshots, only one of thm will be marked as 'default' and will have a quick access path when retrieving multiple audit entries  */
  snapshots: Array<AuditSnapshot>;
  /**  Date/Time when Event happened, it is not necessarily when it was registered  */
  triggeredAt: Scalars['DateTime'];
  /**  The list of RealmObjects (typically Device entries) witnessing the context of this Audit Event/Entry  */
  witnesses: Array<RealmObject>;
};

export type AuditEntryEvent = AuditEntry | ErrorInfo;

/** Audit entries filter data. */
export type AuditEntryFilter = {
  /**  List of Audit Category IDs. If not specified, entries from all categories are returned  */
  categories?: InputMaybe<Array<Scalars['ID']>>;
  /**  From date-time. If not specified, last hour is assumed  */
  from?: InputMaybe<Scalars['DateTime']>;
  /**  If limit is not specified, 100 is assumed. Limit cannot be more than 100  */
  limit?: InputMaybe<Scalars['Int']>;
  /**  If start is not specified, 0 is assumed  */
  start?: InputMaybe<Scalars['Int']>;
  /**  To date-time. If not specified, current time is assumed  */
  to?: InputMaybe<Scalars['DateTime']>;
  /**  List of Realm Object IDs  */
  witnesses: Array<Scalars['ID']>;
};

/**
 * AuditEntry can have zero, one or more snapshots attached to it.
 * Snapshot[s] provide the visual queues for the Audit Entry/Event visualization for the end-user.
 * Only one of these snapshots will have 'default' property marked as true, and it will be provided when requesting multiple entries with snapshots included.
 * It is possible to get the remaining snapshots when running query for individual AuditEntry.id.
 */
export type AuditSnapshot = {
  __typename?: 'AuditSnapshot';
  /** Flag if particular snapshot is a default one to be shown with an Event */
  default: Scalars['Boolean'];
  /** Snapshot, base64 encoded into String */
  snapshot: Scalars['String'];
  /** Tags allow to keep additional convenience annotations and are stored as Key->Value mappings */
  tags: Array<KeyValue>;
  /** Type is provided by VAE and is not intended for end-user consumption, it is ID-like */
  type: Scalars['String'];
};

export enum AuthType {
  HttpBasic = 'HTTP_BASIC',
  HttpDigest = 'HTTP_DIGEST',
  NoAuth = 'NO_AUTH'
}

export type AvatarMetric = {
  __typename?: 'AvatarMetric';
  /**  Dimension  */
  dimension: MetricDimension;
  /**  Metric name  */
  key: AvatarMetricName;
  /**  Description of metric  */
  name: Scalars['String'];
};

export enum AvatarMetricName {
  ChannelArchiveScheduledBytes = 'CHANNEL_ARCHIVE_SCHEDULED_BYTES',
  ChannelJitterMs = 'CHANNEL_JITTER_MS',
  /**  Channel statistics  */
  ChannelRttMs = 'CHANNEL_RTT_MS',
  ChannelSentArchiveBps = 'CHANNEL_SENT_ARCHIVE_BPS',
  ChannelSentLiveBps = 'CHANNEL_SENT_LIVE_BPS',
  /**  Channel bandwidth statistics  */
  ChannelTotalInboundBps = 'CHANNEL_TOTAL_INBOUND_BPS',
  CpuIdle = 'CPU_IDLE',
  CpuIowait = 'CPU_IOWAIT',
  /**  Cpu statistics  */
  CpuUsage = 'CPU_USAGE',
  DiskIoPct = 'DISK_IO_PCT',
  LocalStreamingArchiveBps = 'LOCAL_STREAMING_ARCHIVE_BPS',
  LocalStreamingClientsCount = 'LOCAL_STREAMING_CLIENTS_COUNT',
  /**  Local media downloads  */
  LocalStreamingLiveBps = 'LOCAL_STREAMING_LIVE_BPS',
  /**  Memory statistics  */
  MemFreePct = 'MEM_FREE_PCT'
}

export enum BaseDeviceType {
  Avatar = 'AVATAR',
  Camera = 'CAMERA',
  Gateway = 'GATEWAY',
  Sensor = 'SENSOR'
}

export enum BasicAccessConfiguration {
  LimitedAudioSupport = 'limitedAudioSupport',
  LimitedAuditAccess = 'limitedAuditAccess',
  LimitedExportTime = 'limitedExportTime',
  LimitedGisAccess = 'limitedGISAccess',
  LimitedImportCamerasAccess = 'limitedImportCamerasAccess',
  LimitedMonitorCount = 'limitedMonitorCount',
  LimitedRealmAdministration = 'limitedRealmAdministration',
  LimitedReportsAccess = 'limitedReportsAccess',
  LimitedSetsAccess = 'limitedSetsAccess',
  LimitedSpeedList = 'limitedSpeedList',
  LimitedVideoAnalyticsAccess = 'limitedVideoAnalyticsAccess',
  LimitedZonesAccess = 'limitedZonesAccess'
}

export enum BoundaryFind {
  Next = 'NEXT',
  Prev = 'PREV'
}

export type BrandInfo = {
  __typename?: 'BrandInfo';
  iconUrl: Scalars['String'];
  logoUrl: Scalars['String'];
  name: Scalars['String'];
  shortName: Scalars['String'];
  website: Scalars['String'];
};

export type CameraLog = {
  __typename?: 'CameraLog';
  message: Scalars['String'];
  severity: LogSeverity;
  time: Scalars['DateTime'];
};

export type CameraMetric = {
  __typename?: 'CameraMetric';
  /**  FA id  */
  dfaId: Scalars['Int'];
  /**  Dimension  */
  dimension: MetricDimension;
  /**  Metric name  */
  key: CameraMetricName;
  /**  Description of metric  */
  name: Scalars['String'];
};

export enum CameraMetricName {
  /**  Camera media bit-rate, per stream. History on camera media streams bitrate  */
  Bitrate = 'BITRATE',
  /**  Percentage of LINK storage utilized by devices and streams. History on scheduled and on-demand media requested to be delivered to the cloud  */
  CloudArchiveBps = 'CLOUD_ARCHIVE_BPS',
  CloudArchiveModBps = 'CLOUD_ARCHIVE_MOD_BPS',
  CloudLiveBps = 'CLOUD_LIVE_BPS',
  CloudLiveModBps = 'CLOUD_LIVE_MOD_BPS',
  /**  History on camera media streams utilizing LINK local storage  */
  LinkStoragePct = 'LINK_STORAGE_PCT',
  LocalArchiveModBps = 'LOCAL_ARCHIVE_MOD_BPS',
  LocalLiveModBps = 'LOCAL_LIVE_MOD_BPS',
  /**  Status, Errors and Warnings. History on processors status changes (count) */
  Status = 'STATUS',
  StreamFps = 'STREAM_FPS',
  /**  Percentage of media requested for on-demand and scheduled delivery. Media stream statistics  */
  StreamGop = 'STREAM_GOP',
  StreamJitter = 'STREAM_JITTER',
  StreamRestarts = 'STREAM_RESTARTS',
  StreamRtpPckLoss = 'STREAM_RTP_PCK_LOSS'
}

export type ChangePasswordInput = {
  currentPassword: Scalars['String'];
  newPassword: Scalars['String'];
  userId: Scalars['ID'];
};

export type ChannelBenchmark = {
  __typename?: 'ChannelBenchmark';
  error?: Maybe<Scalars['String']>;
  startedAt?: Maybe<Scalars['DateTime']>;
  tcpDown?: Maybe<ChannelStatistics>;
  tcpUp?: Maybe<ChannelStatistics>;
};

export type ChannelStatistics = {
  __typename?: 'ChannelStatistics';
  bitsPerSecond?: Maybe<Scalars['Float']>;
  bytes?: Maybe<Scalars['Int']>;
  maxRtt?: Maybe<Scalars['Int']>;
  maxSndCwnd?: Maybe<Scalars['Int']>;
  meanRtt?: Maybe<Scalars['Int']>;
  minRtt?: Maybe<Scalars['Int']>;
  retransmits?: Maybe<Scalars['Int']>;
};

export enum ChannelStatus {
  DelayedCatchup = 'DELAYED_CATCHUP',
  DelayedDegraded = 'DELAYED_DEGRADED',
  Ontime = 'ONTIME'
}

export type CreateResult = {
  __typename?: 'CreateResult';
  id: Scalars['ID'];
  warning?: Maybe<Scalars['String']>;
  warningFields?: Maybe<Array<WarningField>>;
};

/** Current Realm */
export type CurrentRealm = RealmObject & {
  __typename?: 'CurrentRealm';
  createdAt?: Maybe<Scalars['DateTime']>;
  /** Object ID (UUID) */
  id: Scalars['ID'];
  imageMapConfig?: Maybe<Scalars['String']>;
  /** Max duration of the video to upload in minutes */
  maxDownloadLength?: Maybe<Scalars['Int']>;
  modifiedAt?: Maybe<Scalars['DateTime']>;
  /** Object name */
  name: Scalars['String'];
  sharedViews?: Maybe<Scalars['String']>;
  type: RealmObjectType;
};

export type CurrentRealmInput = {
  id: Scalars['ID'];
  imageMapConfig?: InputMaybe<Scalars['String']>;
  sharedViews?: InputMaybe<Scalars['String']>;
};

/** Functional Aspect descriptor for "Avatar" aspect. */
export type Dfa_Avatar = DeviceFunctionalAspect & {
  __typename?: 'DFA_Avatar';
  apiKey?: Maybe<Scalars['String']>;
  avatarLoad?: Maybe<Scalars['Int']>;
  channelBenchmark?: Maybe<ChannelBenchmark>;
  channelStatus?: Maybe<ChannelStatus>;
  channelTurnaroundTime?: Maybe<StatTime>;
  deliveryQueue?: Maybe<Scalars['Int']>;
  deliveryQueueUploadTime?: Maybe<Scalars['Int']>;
  /**  Device where aspect is connected  */
  device?: Maybe<Device>;
  dsConfiguredState?: Maybe<DsConfiguredState>;
  dsRunningState?: Maybe<DsRunningState>;
  /**  True if aspect is enabled for the device  */
  enabled: Scalars['Boolean'];
  encryptionKey?: Maybe<EncryptionKeyInfo>;
  /**  internal use only  */
  extended?: Maybe<Scalars['JSONObject']>;
  /**  Aspect Health settings and status  */
  health: AspectHealth;
  id: Scalars['ID'];
  /**  Actual instances of aspects on the same device which produce inputs for the aspect.  */
  inputAspects: Array<DeviceFunctionalAspect>;
  isLink?: Maybe<Scalars['Boolean']>;
  lastStatusUpdate?: Maybe<Scalars['DateTime']>;
  localStorage?: Maybe<LocalStorage>;
  /**  Aspect name, suitable for GUI presentation  */
  name: Scalars['String'];
  packetArrivalJitterTime?: Maybe<StatTime>;
  platform?: Maybe<Scalars['String']>;
  pushEventEndPoint?: Maybe<Scalars['String']>;
  software?: Maybe<SoftwareInfo>;
  statusUpdateInterval?: Maybe<Scalars['Int']>;
  storageUsage?: Maybe<StorageUsage>;
  supportsReboot?: Maybe<Scalars['Boolean']>;
  /**
   *  Source template from which aspect was created.
   * Can act as a 'subtype' of aspect, specifying for example an exact kind of analytics.
   */
  template: FunctionalAspectTemplate;
  turnaroundTime?: Maybe<Scalars['Int']>;
  /**  Aspect type (video/analytic/etc..), exactly corresponds to the type specified by template  */
  type: DeviceFunctionalAspectType;
  upTime?: Maybe<Scalars['Int']>;
  uploadBandwidthCap?: Maybe<Scalars['Float']>;
  vaeImageUpdate?: Maybe<Scalars['Boolean']>;
  vaeUpdates?: Maybe<Array<VaeUpdate>>;
  vmxVideoStreamingMode?: Maybe<VmxVideoStreamingMode>;
  webRtcEnabled?: Maybe<Scalars['Boolean']>;
};

export type Dfa_Gateway = DeviceFunctionalAspect & {
  __typename?: 'DFA_Gateway';
  /**  Associated devices  */
  associatedGatewayDevices: Array<AssociatedGatewayDevice>;
  /**  Device where aspect is connected  */
  device?: Maybe<Device>;
  /**  Full list of Lenel devices  */
  devices: Array<GatewayProbeDevice>;
  /**  Full list of Lenel directories  */
  directories: Array<GatewayDirectory>;
  /**  Current Lenel directory  */
  directory: GatewayDirectory;
  /**  True if aspect is enabled for the device  */
  enabled: Scalars['Boolean'];
  /**  Full list of Lenel events  */
  events: Array<GatewayProbeEvent>;
  /**  Aspect Health settings and status  */
  health: AspectHealth;
  id: Scalars['ID'];
  /**  Actual instances of aspects on the same device which produce inputs for the aspect.  */
  inputAspects: Array<DeviceFunctionalAspect>;
  /**  Lenel version  */
  lenelVersion: Scalars['String'];
  /**  Aspect name, suitable for GUI presentation  */
  name: Scalars['String'];
  /**  OpenID Connect token  */
  oidcToken?: Maybe<Scalars['String']>;
  /**  Associated events  */
  subscribedEvents: Array<GatewayEvent>;
  /**  Source template from which aspect was created. Can act as a 'subtype' of aspect, specifying for example an exact kind of analytics.  */
  template: FunctionalAspectTemplate;
  /**  Aspect type (video/analytic/etc..), exactly corresponds to the type specified by template  */
  type: DeviceFunctionalAspectType;
};

/**
 * Functional Aspect descriptor for "Live Media" aspects.
 * Each media stream (video/audio) receives a separate DFA descriptor.
 */
export type Dfa_Media = DeviceFunctionalAspect & {
  __typename?: 'DFA_Media';
  FPS?: Maybe<Scalars['Float']>;
  URL?: Maybe<Scalars['String']>;
  audioCodec?: Maybe<Scalars['String']>;
  averageFPS?: Maybe<Scalars['Float']>;
  averageGOP?: Maybe<Scalars['Float']>;
  averageInterArrivalJitter?: Maybe<Scalars['Float']>;
  cloudArchive: MediaArchiveOption;
  codec?: Maybe<Scalars['String']>;
  /**  Statistic  */
  consumedSpace?: Maybe<Scalars['Float']>;
  /**  Device where aspect is connected  */
  device?: Maybe<Device>;
  /**  Archive settings  */
  edgeArchive: MediaArchiveOption;
  /**  True if aspect is enabled for the device  */
  enabled: Scalars['Boolean'];
  frameRate?: Maybe<Scalars['Float']>;
  /**  Aspect Health settings and status  */
  health: AspectHealth;
  id: Scalars['ID'];
  /**  Actual instances of aspects on the same device which produce inputs for the aspect.  */
  inputAspects: Array<DeviceFunctionalAspect>;
  liveBitrate?: Maybe<Scalars['Float']>;
  /**  Aspect name, suitable for GUI presentation  */
  name: Scalars['String'];
  onvifProfile?: Maybe<Scalars['String']>;
  onvifProfiles?: Maybe<Scalars['JSONObject']>;
  rtpPacketLost?: Maybe<Scalars['Int']>;
  /**  Streams in social networks  */
  sharedStream?: Maybe<Array<StreamShare>>;
  spaceUsageDay?: Maybe<Scalars['Float']>;
  spaceUsageHour?: Maybe<Scalars['Float']>;
  /**  Stream properties  */
  streamType: MediaStreamType;
  /**
   *  Source template from which aspect was created.
   * Can act as a 'subtype' of aspect, specifying for example an exact kind of analytics.
   */
  template: FunctionalAspectTemplate;
  /**  Aspect type (video/analytic/etc..), exactly corresponds to the type specified by template  */
  type: DeviceFunctionalAspectType;
  uptime?: Maybe<Scalars['Int']>;
  videoCodec?: Maybe<Scalars['String']>;
  videoHeight?: Maybe<Scalars['Int']>;
  videoSize?: Maybe<Scalars['String']>;
  videoWidth?: Maybe<Scalars['Int']>;
};

/** Functional Aspect descriptor for "PTZ" aspect. */
export type Dfa_Ptz = DeviceFunctionalAspect & {
  __typename?: 'DFA_PTZ';
  /**  Set of supported command classes (for future, currently is not used)  */
  cmdClassSupport?: Maybe<Array<Ptz_Class>>;
  /**  Device where aspect is connected  */
  device?: Maybe<Device>;
  /**  True if aspect is enabled for the device  */
  enabled: Scalars['Boolean'];
  /**  Aspect Health settings and status  */
  health: AspectHealth;
  id: Scalars['ID'];
  /**  Actual instances of aspects on the same device which produce inputs for the aspect.  */
  inputAspects: Array<DeviceFunctionalAspect>;
  /**  Aspect name, suitable for GUI presentation  */
  name: Scalars['String'];
  ptzConfig?: Maybe<Scalars['String']>;
  /**  PTZ options */
  ptzPanInverted?: Maybe<Scalars['Boolean']>;
  ptzTiltInverted?: Maybe<Scalars['Boolean']>;
  /**
   *  Source template from which aspect was created.
   * Can act as a 'subtype' of aspect, specifying for example an exact kind of analytics.
   */
  template: FunctionalAspectTemplate;
  /**  Aspect type (video/analytic/etc..), exactly corresponds to the type specified by template  */
  type: DeviceFunctionalAspectType;
};

/** Functional Aspect descriptor for Sensors aspects. */
export type Dfa_Sensor = DeviceFunctionalAspect & {
  __typename?: 'DFA_Sensor';
  /**  Device ids which assigned to sensor  */
  associatedDevices?: Maybe<Array<Scalars['String']>>;
  /**  Sensor category (like Door, Fence)  */
  category?: Maybe<AspectSensorCategory>;
  /**  Device where aspect is connected  */
  device?: Maybe<Device>;
  /**  True if aspect is enabled for the device  */
  enabled: Scalars['Boolean'];
  /**  Aspect Health settings and status  */
  health: AspectHealth;
  id: Scalars['ID'];
  /**  Actual instances of aspects on the same device which produce inputs for the aspect.  */
  inputAspects: Array<DeviceFunctionalAspect>;
  /**  Sensor model  */
  model?: Maybe<Scalars['String']>;
  /**  Aspect name, suitable for GUI presentation  */
  name: Scalars['String'];
  /**  Sensor events with description  */
  sensorEvents?: Maybe<Array<SensorEvent>>;
  /**  Sensor serial number  */
  serial?: Maybe<Scalars['String']>;
  /**
   *  Source template from which aspect was created.
   * Can act as a 'subtype' of aspect, specifying for example an exact kind of analytics.
   */
  template: FunctionalAspectTemplate;
  /**  Aspect type (video/analytic/etc..), exactly corresponds to the type specified by template  */
  type: DeviceFunctionalAspectType;
  /**  Selected types of sensor events  */
  userEvents?: Maybe<Array<Scalars['String']>>;
};

/**
 * Functional Aspect descriptor for Analytics aspects.
 * Typically, these Aspects are Analytics performed by VAE.
 */
export type Dfa_Vae = DeviceFunctionalAspect & {
  __typename?: 'DFA_VAE';
  /**  Device where aspect is connected  */
  device?: Maybe<Device>;
  /**  True if aspect is enabled for the device  */
  enabled: Scalars['Boolean'];
  /**  Aspect Health settings and status  */
  health: AspectHealth;
  id: Scalars['ID'];
  /**  Actual instances of aspects on the same device which produce inputs for the aspect.  */
  inputAspects: Array<DeviceFunctionalAspect>;
  /**  Aspect name, suitable for GUI presentation  */
  name: Scalars['String'];
  /**
   *  Source template from which aspect was created.
   * Can act as a 'subtype' of aspect, specifying for example an exact kind of analytics.
   */
  template: FunctionalAspectTemplate;
  /**  Aspect type (video/analytic/etc..), exactly corresponds to the type specified by template  */
  type: DeviceFunctionalAspectType;
  /**  Active VAE config  */
  vaeConfig?: Maybe<VaeConfigFull>;
  /**  VAE features for VAE configurator  */
  vaeFeatures?: Maybe<Array<Scalars['String']>>;
};

export enum DsConfiguredState {
  Off = 'OFF',
  On = 'ON'
}

export enum DsRunningState {
  Running = 'RUNNING',
  Stopped = 'STOPPED'
}

export type DeliveryPriorityInput = {
  deliveryPriority: Scalars['Int'];
  deviceId: Scalars['ID'];
};

/**
 * Device descriptor.
 * Device always belongs to a Realm and has some base configuration shared to device functional aspects.
 */
export type Device = RealmObject & {
  __typename?: 'Device';
  /** Functional aspects (like "media", "events", ...) */
  aspects: Array<DeviceFunctionalAspect>;
  /**  Cloud direct  */
  cloudDirect: Scalars['Boolean'];
  /** General device settings */
  config: DeviceBaseConfig;
  createdAt?: Maybe<Scalars['DateTime']>;
  /** Strategies for content delivery */
  delivery?: Maybe<Scalars['String']>;
  deliveryPriority?: Maybe<Scalars['Int']>;
  /** Do not use, for internal use only */
  deviceType?: Maybe<BaseDeviceType>;
  enabled: Scalars['Boolean'];
  /** Advanced Camera Settings */
  eventType?: Maybe<DeviceEventType>;
  healthStatus: HealthStatus;
  /** Device ID (UUID) */
  id: Scalars['ID'];
  /** Optional location as specified by user */
  location?: Maybe<Scalars['String']>;
  modifiedAt?: Maybe<Scalars['DateTime']>;
  /** Device name */
  name: Scalars['String'];
  /** Avatar, DVR, external system */
  platform?: Maybe<Device>;
  /** GEO position */
  position?: Maybe<LatLng>;
  /** Camera Stream Settings */
  rtpOverTcp?: Maybe<Scalars['Boolean']>;
  rtpTime?: Maybe<Scalars['Boolean']>;
  /** Optional set for authorization policy definition simplification */
  set?: Maybe<Array<ObjectDescriptor>>;
  storageConfig?: Maybe<DeviceStorageConfig>;
  type: RealmObjectType;
  version: Scalars['String'];
  /** Optional zone for authorization policy definition simplification */
  zone?: Maybe<ObjectDescriptor>;
};

/**
 * Generic device configuration settings.
 * These are shared between multiple DeviceFunctionalAspect entries device may have.
 */
export type DeviceBaseConfig = {
  __typename?: 'DeviceBaseConfig';
  configType: DeviceBaseConfigType;
  connect: NetworkConnectDescriptor;
  firmware?: Maybe<Scalars['String']>;
  make?: Maybe<Scalars['String']>;
  model?: Maybe<Scalars['String']>;
  onvifServices?: Maybe<Scalars['String']>;
};

export type DeviceBaseConfigInput = {
  configType: DeviceBaseConfigType;
  connect: NetworkConnectDescriptorInput;
  firmware?: InputMaybe<Scalars['String']>;
  make?: InputMaybe<Scalars['String']>;
  model?: InputMaybe<Scalars['String']>;
  onvifServices?: InputMaybe<Scalars['String']>;
};

/** The paradigm in which device is managed. */
export enum DeviceBaseConfigType {
  /** Demo */
  Demo = 'DEMO',
  /** Gateway */
  Gateway = 'GATEWAY',
  /** On-board */
  Onboard = 'ONBOARD',
  /** Using ONVIF standard */
  Onvif = 'ONVIF',
  /** Sensor */
  Sensor = 'SENSOR',
  /** Using URI */
  Url = 'URL'
}

export enum DeviceCommand {
  AvatarChannelBenchmark = 'AVATAR_CHANNEL_BENCHMARK',
  AvatarDsActivate = 'AVATAR_DS_ACTIVATE',
  AvatarDsDeactivate = 'AVATAR_DS_DEACTIVATE',
  AvatarDsStart = 'AVATAR_DS_START',
  AvatarDsStop = 'AVATAR_DS_STOP',
  AvatarReboot = 'AVATAR_REBOOT',
  AvatarUpdateKey = 'AVATAR_UPDATE_KEY',
  AvatarUpdateSoftware = 'AVATAR_UPDATE_SOFTWARE',
  AvatarUpgradeSoftware = 'AVATAR_UPGRADE_SOFTWARE'
}

export enum DeviceEventType {
  Alert = 'alert',
  Information = 'information'
}

/**
 * Functional Aspect is a descriptor of the abstract functionality.
 * Zero, one or more Aspects may be attached to the Device.
 * Aspects are presented for the easy reasoning what kind of functionality particular device
 * can provide and description of what particular Aspect is and if it is operational.
 */
export type DeviceFunctionalAspect = {
  /**  Device where aspect is connected  */
  device?: Maybe<Device>;
  /**  True if aspect is enabled for the device  */
  enabled: Scalars['Boolean'];
  /**  Aspect Health settings and status  */
  health: AspectHealth;
  id: Scalars['ID'];
  /**  Actual instances of aspects on the same device which produce inputs for the aspect.  */
  inputAspects: Array<DeviceFunctionalAspect>;
  /**  Aspect name, suitable for GUI presentation. In most cases derived from the template name.  */
  name: Scalars['String'];
  /**  Source template from which aspect was created. Can act as a 'subtype' of aspect, specifying for example an exact kind of analytics.  */
  template: FunctionalAspectTemplate;
  /**  Aspect type (video/analytic/etc..), exactly corresponds to the type specified by template  */
  type: DeviceFunctionalAspectType;
};

/**
 * Functional Aspect is a descriptor of the abstract functionality.
 * Zero, one or more Aspects may be attached to the Device.
 * Aspects are presented for the easy reasoning what kind of functionality particular device
 * can provide and description of what particular Aspect is and if it is operational.
 */
export type DeviceFunctionalAspectFilter = {
  /** True if aspect is enabled for the device */
  enabled?: InputMaybe<Scalars['Boolean']>;
  /** Aspect Health settings and status */
  health?: InputMaybe<AspectHealthFilter>;
  /** Aspect name, suitable for GUI presentation */
  name?: InputMaybe<Scalars['String']>;
  /** ID of source template from which aspect was created. */
  templateId?: InputMaybe<Scalars['String']>;
  /** Aspect type (video/analytic/etc..) */
  type?: InputMaybe<DeviceFunctionalAspectType>;
};

export type DeviceFunctionalAspectInput = {
  URL?: InputMaybe<Scalars['String']>;
  /**  Device ids which assigned Sensor  */
  associatedDevices?: InputMaybe<Array<Scalars['String']>>;
  /**  Associated devices  */
  associatedGatewayDevices?: InputMaybe<Array<AssociatedGatewayDeviceInput>>;
  /**  Sensor category (like Door, Fence)  */
  category?: InputMaybe<AspectSensorCategory>;
  cloudArchive?: InputMaybe<MediaArchiveOption>;
  /**  Set of supported command classes (for future, currently is not used)  */
  cmdClassSupport?: InputMaybe<Array<Ptz_Class>>;
  codec?: InputMaybe<Scalars['String']>;
  /**  Lenel devices list  */
  devices?: InputMaybe<Array<GatewayDeviceInput>>;
  /**  Lenel directories list  */
  directories?: InputMaybe<Array<GatewayDirectoryInput>>;
  /**  Current Lenel directory id  */
  directoryId?: InputMaybe<Scalars['String']>;
  /**  Live/Archive settings  */
  edgeArchive?: InputMaybe<MediaArchiveOption>;
  /** True if aspect is enabled for the device */
  enabled: Scalars['Boolean'];
  /**  Lenel events list  */
  events?: InputMaybe<Array<GatewayEventInput>>;
  frameRate?: InputMaybe<Scalars['Float']>;
  id: Scalars['ID'];
  /** Actual instances of aspects on the same device which produce inputs for the aspect. */
  inputAspectIDs: Array<Scalars['ID']>;
  lenelVersion?: InputMaybe<Scalars['String']>;
  /**  Sensor model  */
  model?: InputMaybe<Scalars['String']>;
  /** Aspect name, suitable for GUI presentation. In most cases derived from the template name. */
  name: Scalars['String'];
  /**  OpenID Connect token  */
  oidcToken?: InputMaybe<Scalars['String']>;
  onvifProfile?: InputMaybe<Scalars['String']>;
  onvifProfiles?: InputMaybe<Scalars['JSONObject']>;
  ptzConfig?: InputMaybe<Scalars['String']>;
  ptzPanInverted?: InputMaybe<Scalars['Boolean']>;
  ptzTiltInverted?: InputMaybe<Scalars['Boolean']>;
  pushEventEndPoint?: InputMaybe<Scalars['String']>;
  /**  Sensor events with description  */
  sensorEvents?: InputMaybe<Array<SensorEventInput>>;
  /**  Sensor serial number  */
  serial?: InputMaybe<Scalars['String']>;
  /**  RTMP urls for sharing stream in social networks  */
  sharedStream?: InputMaybe<Array<Scalars['String']>>;
  statusUpdateInterval?: InputMaybe<Scalars['Int']>;
  /**  Stream properties  */
  streamType?: InputMaybe<MediaStreamType>;
  /**  Associated events  */
  subscribedEvents?: InputMaybe<Array<SubscribedGatewayEventInput>>;
  /**
   *  Source template from which aspect was created.
   * Can act as a 'subtype' of aspect, specifying for example an exact kind of analytics.
   */
  templateId: Scalars['String'];
  uploadBandwidthCap?: InputMaybe<Scalars['Float']>;
  /**  Selected types of sensor events  */
  userEvents?: InputMaybe<Array<Scalars['String']>>;
  /**  Changed configurations names  */
  vaeConfigChangedNames?: InputMaybe<Array<Scalars['String']>>;
  /**  Active VAE config name  */
  vaeConfigName?: InputMaybe<Scalars['String']>;
  /**  Subscribed VAE features  */
  vaeFeatures?: InputMaybe<Array<Scalars['String']>>;
  vaeImageUpdate?: InputMaybe<Scalars['Boolean']>;
  videoHeight?: InputMaybe<Scalars['Int']>;
  videoWidth?: InputMaybe<Scalars['Int']>;
  vmxVideoStreamingMode?: InputMaybe<VmxVideoStreamingMode>;
  webRtcEnabled?: InputMaybe<Scalars['Boolean']>;
};

/** Functional Aspect types */
export enum DeviceFunctionalAspectType {
  Avatar = 'AVATAR',
  Gateway = 'GATEWAY',
  Media = 'MEDIA',
  Ptz = 'PTZ',
  Sensor = 'SENSOR',
  Vae = 'VAE'
}

export type DeviceInput = {
  /** Functional aspects (like "media", "events", ...) */
  aspects?: InputMaybe<Array<DeviceFunctionalAspectInput>>;
  /** General device settings */
  config: DeviceBaseConfigInput;
  deliveryPriority?: InputMaybe<Scalars['Int']>;
  enabled: Scalars['Boolean'];
  /** Camera Setting */
  eventType?: InputMaybe<DeviceEventType>;
  /** Optional location as specified by user */
  location?: InputMaybe<Scalars['String']>;
  /** Device name */
  name: Scalars['String'];
  /** Avatar, DVR, external system */
  platformId?: InputMaybe<Scalars['ID']>;
  /** GEO position */
  position?: InputMaybe<LatLngInput>;
  rtpOverTcp?: InputMaybe<Scalars['Boolean']>;
  rtpTime?: InputMaybe<Scalars['Boolean']>;
  /** Optional set for authorization policy definition simplification */
  setId?: InputMaybe<Array<Scalars['ID']>>;
  storageConfig?: InputMaybe<DeviceStorageConfigInput>;
  /** Optional zone for authorization policy definition simplification */
  zoneId?: InputMaybe<Scalars['ID']>;
};

export type DeviceProbe = {
  __typename?: 'DeviceProbe';
  /** Functional aspects (like "media", "events", ...) */
  aspects: Array<DeviceFunctionalAspect>;
  config: DeviceBaseConfig;
  name?: Maybe<Scalars['String']>;
  /** Default value for follow rtp time */
  rtpTime?: Maybe<Scalars['Boolean']>;
  /** Video snapshots for Video aspects */
  snapshots: Array<Scalars['String']>;
};

export type DeviceProbeInput = {
  configType: DeviceBaseConfigType;
  connect: NetworkConnectDescriptorInput;
  platformId?: InputMaybe<Scalars['ID']>;
  sensorModel?: InputMaybe<Scalars['String']>;
};

export type DeviceStorageConfig = {
  __typename?: 'DeviceStorageConfig';
  storagePool: StoragePool;
};

export type DeviceStorageConfigInput = {
  storagePoolId: Scalars['ID'];
};

export type DeviceTemplate = {
  __typename?: 'DeviceTemplate';
  make: Scalars['String'];
  models: Array<DeviceTemplateModel>;
};

export type DeviceTemplateModel = {
  __typename?: 'DeviceTemplateModel';
  model: Scalars['String'];
  url: Scalars['String'];
};

export type EmailAddresses = {
  from?: InputMaybe<Scalars['String']>;
  to?: InputMaybe<Scalars['String']>;
};

export enum EmailAuth {
  No = 'NO',
  Pass = 'PASS'
}

export type EncryptionKeyInfo = {
  __typename?: 'EncryptionKeyInfo';
  isValid?: Maybe<Scalars['Boolean']>;
  issuedAt?: Maybe<Scalars['DateTime']>;
};

export type ErrorInfo = {
  __typename?: 'ErrorInfo';
  createdAt: Scalars['DateTime'];
  error: Scalars['String'];
};

/**
 * Health Gravity defines how aspect health is reflected on device health (how to roll health statuses up).
 * Each individual Aspect operation status can take values from HealthStatus enum (from "core").
 */
export enum Fa_HealthGravity {
  /** If aspect with BEST_EFFORT gravity is DEAD, it is rolling up as NORMAL (not DEGRADED or BROKEN) */
  BestEffort = 'BEST_EFFORT',
  /** If aspect with CRITICAL gravity is DEAD, entire device is considered to be BROKEN */
  Critical = 'CRITICAL',
  /** If aspect with NORMAL gravity is DEAD, it is rolling up as DEGRADED (not BROKEN) */
  Normal = 'NORMAL'
}

export type Feature = {
  __typename?: 'Feature';
  desc: FeatureDesc;
  name: Scalars['String'];
  unitsSubscribed: Scalars['Float'];
  unitsUsed: Scalars['Float'];
};

/** Used to list available features */
export type FeatureDesc = {
  __typename?: 'FeatureDesc';
  displayName: Scalars['String'];
  name: Scalars['String'];
  type: FeatureType;
  unitType: Scalars['String'];
};

export type FeatureInput = {
  name: Scalars['String'];
  unitsSubscribed: Scalars['Float'];
};

export enum FeatureType {
  Default = 'DEFAULT',
  Storagepool = 'STORAGEPOOL'
}

export type Filter = {
  /** Features names we should filter */
  features?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  /** Realm IDs we should filter */
  realms?: InputMaybe<Array<InputMaybe<Scalars['String']>>>;
  /** Array of two DateTime: From - To */
  streamUsagePeriod?: InputMaybe<StreamUsagePeriod>;
  /** If we should return usage. Increases response time greatly! */
  usage?: InputMaybe<Scalars['Boolean']>;
};

/**
 * System-defined templates to instantiate device functional aspects.
 * A template must be created for each aspect kind used in the system.
 * For example, every kind of analytics aspect must have a registered template.
 */
export type FunctionalAspectTemplate = {
  __typename?: 'FunctionalAspectTemplate';
  baseFeature?: Maybe<Scalars['String']>;
  defaultFeature?: Maybe<Scalars['String']>;
  engine?: Maybe<Scalars['String']>;
  features?: Maybe<Array<VaeFeature>>;
  /** Unique template ID, a readable constant for machine interpretation, like 'video', 'audio', etc. */
  id: Scalars['String'];
  /** Aspect name, suitable for GUI presentation */
  name: Scalars['String'];
  /** Display order of the aspect */
  order: Scalars['Int'];
  /** Aspect type (video/analytic/etc..) */
  type: DeviceFunctionalAspectType;
};

export type GeoLayer = {
  __typename?: 'GEOLayer';
  data: Scalars['String'];
  mime: Scalars['String'];
  name: Scalars['String'];
};

export type GeoLayerInput = {
  data: Scalars['String'];
  mime: Scalars['String'];
  name: Scalars['String'];
};

export type GeoLayers = {
  __typename?: 'GEOLayers';
  geoLayers: Array<GeoLayer>;
};

export type GeoLayersInput = {
  geoLayers: Array<GeoLayerInput>;
};

export type GatewayDeviceInput = {
  id: Scalars['ID'];
  name: Scalars['String'];
};

export type GatewayDirectoriesProbe = {
  __typename?: 'GatewayDirectoriesProbe';
  deviceProbe: DeviceProbe;
  directories: Array<GatewayDirectory>;
};

export type GatewayDirectoriesProbeInput = {
  connect: NetworkConnectDescriptorInput;
  model: GatewayModel;
  platformId: Scalars['String'];
};

export type GatewayDirectory = {
  __typename?: 'GatewayDirectory';
  id: Scalars['ID'];
  name: Scalars['String'];
};

export type GatewayDirectoryInput = {
  id: Scalars['ID'];
  name: Scalars['String'];
};

export type GatewayEvent = {
  __typename?: 'GatewayEvent';
  id: Scalars['ID'];
  name: Scalars['String'];
  type: Scalars['String'];
};

export type GatewayEventInput = {
  id: Scalars['ID'];
  name: Scalars['String'];
  type: Scalars['String'];
};

export enum GatewayModel {
  Lenel = 'Lenel'
}

export type GatewayProbe = {
  __typename?: 'GatewayProbe';
  devices: Array<GatewayProbeDevice>;
  events: Array<GatewayProbeEvent>;
};

export type GatewayProbeDevice = {
  __typename?: 'GatewayProbeDevice';
  id: Scalars['ID'];
  name: Scalars['String'];
};

export type GatewayProbeEvent = {
  __typename?: 'GatewayProbeEvent';
  id: Scalars['ID'];
  name: Scalars['String'];
};

export type GatewayProbeInput = {
  connect: NetworkConnectDescriptorInput;
  directoryId: Scalars['String'];
  model: GatewayModel;
  platformId: Scalars['String'];
  token?: InputMaybe<Scalars['String']>;
  version: Scalars['String'];
};

/** Generic Realm object */
export type GenericObject = RealmObject & {
  __typename?: 'GenericObject';
  createdAt?: Maybe<Scalars['DateTime']>;
  /** Object ID (UUID) */
  id: Scalars['ID'];
  modifiedAt?: Maybe<Scalars['DateTime']>;
  /** Object name */
  name: Scalars['String'];
  type: RealmObjectType;
};

export type Group = RealmObject & {
  __typename?: 'Group';
  createdAt?: Maybe<Scalars['DateTime']>;
  id: Scalars['ID'];
  isSystemManaged: Scalars['Boolean'];
  modifiedAt?: Maybe<Scalars['DateTime']>;
  name: Scalars['String'];
  policies: Array<Policy>;
  type: RealmObjectType;
  users: Array<User>;
};

export type GroupInput = {
  addPolicyIds?: InputMaybe<Array<Scalars['ID']>>;
  addUserIds?: InputMaybe<Array<Scalars['ID']>>;
  name?: InputMaybe<Scalars['String']>;
  removePolicyIds?: InputMaybe<Array<Scalars['ID']>>;
  removeUserIds?: InputMaybe<Array<Scalars['ID']>>;
};

export type Gui = {
  __typename?: 'Gui';
  description: Scalars['String'];
  /**  GUI ID (UUID)  */
  id: Scalars['ID'];
  /**  GUI name  */
  name: Scalars['String'];
  url: Scalars['String'];
};

/**
 * Individual item health status.
 * If item was not enabled, status is always assumed to be OFF.
 * For enabled items, values are PENDING | NORMAL | DEGRADED | BROKEN
 */
export enum HealthStatus {
  Broken = 'BROKEN',
  Degraded = 'DEGRADED',
  Normal = 'NORMAL',
  Off = 'OFF',
  Pending = 'PENDING'
}

export type Hierarchy = {
  __typename?: 'Hierarchy';
  id: Scalars['ID'];
  level: HierarchyLevel;
  name: Scalars['String'];
};

export type HierarchyInput = {
  id: Scalars['ID'];
  level?: InputMaybe<HierarchyLevelInput>;
  name?: InputMaybe<Scalars['String']>;
};

export type HierarchyLevel = {
  __typename?: 'HierarchyLevel';
  id: Scalars['ID'];
  labelIds: Array<Scalars['ID']>;
  levels?: Maybe<Array<HierarchyLevel>>;
  name: Scalars['String'];
};

export type HierarchyLevelInput = {
  id: Scalars['ID'];
  labelIds: Array<Scalars['ID']>;
  levels: Array<HierarchyLevelInput>;
  name: Scalars['String'];
};

export type ImageMap = {
  __typename?: 'ImageMap';
  base64: Scalars['String'];
  id: Scalars['ID'];
  name: Scalars['String'];
  objects: Array<ImageMapObject>;
  order: Scalars['Int'];
};

export type ImageMapConfig = {
  __typename?: 'ImageMapConfig';
  sets: Array<ImageMapSet>;
};

export type ImageMapInput = {
  base64: Scalars['String'];
  id: Scalars['ID'];
  name: Scalars['String'];
  objects: Array<ImageMapObjectInput>;
  order: Scalars['Int'];
};

export type ImageMapLayer = {
  __typename?: 'ImageMapLayer';
  id: Scalars['ID'];
  maps: Array<ImageMap>;
  name: Scalars['String'];
};

export type ImageMapLayerInput = {
  id: Scalars['ID'];
  maps: Array<ImageMapInput>;
  name: Scalars['String'];
};

export type ImageMapObject = {
  __typename?: 'ImageMapObject';
  id: Scalars['ID'];
  objectId: Scalars['ID'];
  position: Position;
};

export type ImageMapObjectInput = {
  id: Scalars['ID'];
  objectId: Scalars['ID'];
  position: PositionInput;
};

export type ImageMapSet = {
  __typename?: 'ImageMapSet';
  id: Scalars['ID'];
  layers: Array<ImageMapLayer>;
  name: Scalars['String'];
};

export type ImageMapSetInput = {
  id: Scalars['ID'];
  layers: Array<ImageMapLayerInput>;
  name: Scalars['String'];
};

export enum ImageMapUpdateAction {
  DeleteLayer = 'DELETE_LAYER',
  DeleteObject = 'DELETE_OBJECT',
  DeleteSet = 'DELETE_SET',
  InsertLayer = 'INSERT_LAYER',
  InsertObject = 'INSERT_OBJECT',
  InsertSet = 'INSERT_SET',
  RenameLayer = 'RENAME_LAYER',
  RenameSet = 'RENAME_SET',
  UpdateLayer = 'UPDATE_LAYER',
  UpdateMap = 'UPDATE_MAP',
  UpdateObject = 'UPDATE_OBJECT',
  UpdateSet = 'UPDATE_SET'
}

export type ImageMapUpdateNotification = {
  __typename?: 'ImageMapUpdateNotification';
  action: ImageMapUpdateAction;
  layer?: Maybe<ImageMapLayer>;
  layerId?: Maybe<Scalars['ID']>;
  layerName?: Maybe<Scalars['String']>;
  map?: Maybe<ImageMap>;
  mapId?: Maybe<Scalars['ID']>;
  object?: Maybe<ImageMapObject>;
  objectId?: Maybe<Scalars['ID']>;
  realmId: Scalars['String'];
  set?: Maybe<ImageMapSet>;
  setId?: Maybe<Scalars['ID']>;
  setName?: Maybe<Scalars['String']>;
  updateId: Scalars['ID'];
  version: Scalars['String'];
};

/** Generic Key->Value data */
export type KeyValue = {
  __typename?: 'KeyValue';
  key: Scalars['String'];
  value: Scalars['String'];
};

export type KeyValueInput = {
  key: Scalars['String'];
  value: Scalars['String'];
};

export type Label = {
  __typename?: 'Label';
  id: Scalars['ID'];
  name: Scalars['String'];
  objects: Array<LabelObject>;
  type: LabelType;
};

export type LabelInput = {
  id: Scalars['ID'];
  name: Scalars['String'];
  objectIds?: InputMaybe<Array<Scalars['ID']>>;
};

export type LabelObject = {
  __typename?: 'LabelObject';
  objectId: Scalars['ID'];
  type: RealmObjectType;
};

export type LabelOrHierarchyUpdate = {
  __typename?: 'LabelOrHierarchyUpdate';
  itemIds: Array<Scalars['ID']>;
  realmId: Scalars['ID'];
  type: LabelOrHierarchyUpdateType;
};

export enum LabelOrHierarchyUpdateType {
  Delete = 'DELETE',
  Insert = 'INSERT',
  Update = 'UPDATE'
}

export enum LabelType {
  Label = 'LABEL',
  Set = 'SET',
  Zone = 'ZONE'
}

export type LatLng = {
  __typename?: 'LatLng';
  alt?: Maybe<Scalars['Float']>;
  lat: Scalars['Float'];
  lng: Scalars['Float'];
};

export type LatLngInput = {
  alt?: InputMaybe<Scalars['Float']>;
  lat?: InputMaybe<Scalars['Float']>;
  lng?: InputMaybe<Scalars['Float']>;
};

export type License = {
  __typename?: 'License';
  isAccepted: Scalars['Boolean'];
  text: Scalars['String'];
};

export type LocalStorage = {
  __typename?: 'LocalStorage';
  enabled: Scalars['Boolean'];
  pool: PoolLocalStorage;
  strategy: Scalars['String'];
  ver: Scalars['String'];
};

export type LocalStorageInput = {
  enabled: Scalars['Boolean'];
  pool: PoolLocalStorageInput;
  strategy: Scalars['String'];
  ver: Scalars['String'];
};

export enum LogSeverity {
  Debug = 'DEBUG',
  Error = 'ERROR',
  Fatal = 'FATAL',
  Info = 'INFO',
  Warn = 'WARN'
}

export enum MediaArchiveOption {
  Continuous = 'CONTINUOUS',
  Events = 'EVENTS',
  Live = 'LIVE',
  None = 'NONE',
  Schedule = 'SCHEDULE'
}

export enum MediaStreamType {
  Audio = 'AUDIO',
  Video = 'VIDEO'
}

/** Meta Classifier holds the single 'interpreted' value and may contain additional key-value attributes */
export type MetaClassifier = {
  __typename?: 'MetaClassifier';
  attributes: Array<KeyValue>;
  value: Scalars['String'];
};

/** Metadata entry, identified by Key, holds Classifier */
export type MetaEntry = {
  __typename?: 'MetaEntry';
  key: Scalars['String'];
  metaClass: MetaClassifier;
};

export enum MetricDimension {
  Bps = 'bps',
  Bytes = 'bytes',
  Fps = 'fps',
  Ms = 'ms',
  Pcs = 'pcs',
  Pct = 'pct',
  Status = 'status'
}

export type ModifiedByInfo = {
  __typename?: 'ModifiedByInfo';
  realmId: Scalars['ID'];
  userId: Scalars['ID'];
};

export type Mutation = {
  __typename?: 'Mutation';
  /**  accept End User License Agreement  */
  acceptLicense: Scalars['Boolean'];
  /**  acknowledge event  */
  acknowledgeEvent: Scalars['Boolean'];
  /**  add new realm subscription  */
  addSubscription?: Maybe<RealmSubscription>;
  /**  cancel AOD request  */
  aodCancel?: Maybe<Scalars['Boolean']>;
  /**  pause AOD request  */
  aodPause?: Maybe<Scalars['Boolean']>;
  /**  resume AOD request  */
  aodResume?: Maybe<Scalars['Boolean']>;
  /**  add new AOD request  */
  aodSubmit: Array<AodRequest>;
  /**  assign labels to object  */
  assignLabels: Scalars['Boolean'];
  /**  change delivery priority  */
  changeDeliveryPriority: Scalars['Boolean'];
  /**  change config of local storage for avatar  */
  changeLocalStorage: Scalars['Boolean'];
  /**  change user password  */
  changePassword: Scalars['Boolean'];
  /**  create avatar API key  */
  createAvatarApiKey: Scalars['Boolean'];
  /**  add new device  */
  createDevice: CreateResult;
  /**  add new gateway device  */
  createGatewayDevice: CreateResult;
  /**  create group  */
  createGroup: CreateResult;
  /**  create new policy  */
  createPolicy: CreateResult;
  /**  create new policy statement  */
  createPolicyStatement: CreateResult;
  /**  add new sensor device  */
  createSensorDevice: CreateResult;
  /**  create set  */
  createSet: CreateResult;
  /**  create new user  */
  createUser: CreateResult;
  /**  add new VAE config  */
  createVaeConfig: Scalars['Boolean'];
  /**  create new zone  */
  createZone: CreateResult;
  /**  delete device  */
  deleteDevice: Scalars['Boolean'];
  /**  delete group  */
  deleteGroup: Scalars['Boolean'];
  /**  delete hierarchy  */
  deleteHierarchy: Scalars['Boolean'];
  /**  delete image map layer  */
  deleteImageMapLayer: Scalars['Boolean'];
  /**  delete image map layer  */
  deleteImageMapObject: Scalars['Boolean'];
  /**  delete image map set  */
  deleteImageMapSet: Scalars['Boolean'];
  /**  delete label  */
  deleteLabel: Scalars['Boolean'];
  /**  delete policy  */
  deletePolicy: Scalars['Boolean'];
  /**  delete policy statement  */
  deletePolicyStatement: Scalars['Boolean'];
  /**  delete set  */
  deleteSet: Scalars['Boolean'];
  /**  delete realm subscription  */
  deleteSubscription?: Maybe<Scalars['Int']>;
  /**  delete user  */
  deleteUser: Scalars['Boolean'];
  /**  delete VAE config  */
  deleteVaeConfig: Scalars['Boolean'];
  /**  delete zone  */
  deleteZone: Scalars['Boolean'];
  /**  perform device command  */
  deviceCommand: Scalars['Boolean'];
  /**  acknowledgement multiple events  */
  eventsAcknowledgement: Scalars['Boolean'];
  /**  add new hierarchy  */
  insertHierarchy: Hierarchy;
  /**  add new layer to image map  */
  insertImageMapLayer: Scalars['Boolean'];
  /**  add new object to image map  */
  insertImageMapObject: Scalars['Boolean'];
  /**  add new image map set  */
  insertImageMapSet: Scalars['Boolean'];
  /**  add new labels  */
  insertLabels: Array<Label>;
  /**  modify realm subscription  */
  modifySubscription?: Maybe<RealmSubscription>;
  /**  Working with preset positions. Preset positions are stored in cameras  */
  ptzPreset: Scalars['Boolean'];
  /**  Center camera to position  */
  ptzRel: Scalars['Boolean'];
  /**  Move (or change zoom, focus, iris, etc.) camera with specific speed  */
  ptzSpeed: Scalars['Boolean'];
  /**  Move (or change zoom, focus, iris, etc.) camera step by step  */
  ptzStep: Scalars['Boolean'];
  /**  purge Avatar queue  */
  purgeAvatarQueue: Scalars['Boolean'];
  /**  regenerate avatar API key  */
  regenerateAvatarApiKey: Scalars['Boolean'];
  /**  remove avatar API key  */
  removeAvatarApiKey: Scalars['Boolean'];
  /**  remove labels from object  */
  removeLabels: Scalars['Boolean'];
  /**  rename image map layer  */
  renameImageMapLayer: Scalars['Boolean'];
  /**  rename image map set  */
  renameImageMapSet: Scalars['Boolean'];
  /**  rename VAE config  */
  renameVaeConfig: Scalars['Boolean'];
  /**  set user password, password will be marked as expired  */
  setPassword: Scalars['Boolean'];
  /**  set current user realm  */
  setUserRealm: Scalars['Boolean'];
  /**  unblock user  */
  unblockUser: Scalars['Boolean'];
  /**  set current realm parameters  */
  updateCurrentRealm: Scalars['Boolean'];
  /**  update device  */
  updateDevice: UpdateResult;
  /**  store geo layers  */
  updateGeoLayers?: Maybe<Scalars['Boolean']>;
  /**  update group  */
  updateGroup: Scalars['Boolean'];
  /**  update hierarchy  */
  updateHierarchy: Scalars['Boolean'];
  /**  update image map  */
  updateImageMap: Scalars['Boolean'];
  /**  update image map layer  */
  updateImageMapLayer: Scalars['Boolean'];
  /**  update image map layer  */
  updateImageMapObject: Scalars['Boolean'];
  /**  update image map set  */
  updateImageMapSet: Scalars['Boolean'];
  /**  update label  */
  updateLabel: Scalars['Boolean'];
  /**  update policy  */
  updatePolicy: Scalars['Boolean'];
  /**  update policy statement  */
  updatePolicyStatement: Scalars['Boolean'];
  /**  update device position  */
  updatePosition: Scalars['Boolean'];
  /**  update current realm  */
  updateRealm?: Maybe<Scalars['Boolean']>;
  /**  update set  */
  updateSet: Scalars['Boolean'];
  /**  SOLID config specific, not public  */
  updateSolidConfig: Scalars['Boolean'];
  /**  SOLID config specific, not public  */
  updateSolidConfigCurrentView: Scalars['Boolean'];
  /**  update user  */
  updateUser: Scalars['Boolean'];
  /**  update zone  */
  updateZone: Scalars['Boolean'];
  /**  validate add realm subscription  */
  validateAddSubscription?: Maybe<Scalars['Int']>;
  /**  validate email  */
  validateEmail?: Maybe<Scalars['Boolean']>;
  /**  validate modify realm subscription  */
  validateModifySubscription?: Maybe<Scalars['Int']>;
};


export type MutationAcknowledgeEventArgs = {
  context: Scalars['ID'];
  note?: InputMaybe<Scalars['String']>;
  triggeredAt: Scalars['DateTime'];
};


export type MutationAddSubscriptionArgs = {
  realmSubscription: RealmSubscriptionInput;
};


export type MutationAodCancelArgs = {
  requestIds: Array<Scalars['ID']>;
};


export type MutationAodPauseArgs = {
  requestId: Scalars['ID'];
};


export type MutationAodResumeArgs = {
  requestId: Scalars['ID'];
};


export type MutationAodSubmitArgs = {
  input: AodRequestInput;
};


export type MutationAssignLabelsArgs = {
  ids: Array<Scalars['ID']>;
  objectId: Scalars['ID'];
};


export type MutationChangeDeliveryPriorityArgs = {
  devices: Array<DeliveryPriorityInput>;
};


export type MutationChangeLocalStorageArgs = {
  id: Scalars['ID'];
  input: LocalStorageInput;
};


export type MutationChangePasswordArgs = {
  input: ChangePasswordInput;
};


export type MutationCreateAvatarApiKeyArgs = {
  id: Scalars['ID'];
};


export type MutationCreateDeviceArgs = {
  device: DeviceInput;
};


export type MutationCreateGatewayDeviceArgs = {
  device: DeviceInput;
};


export type MutationCreateGroupArgs = {
  group: GroupInput;
};


export type MutationCreatePolicyArgs = {
  policy: PolicyInput;
};


export type MutationCreatePolicyStatementArgs = {
  policyId: Scalars['ID'];
  statement: PolicyStatementInput;
};


export type MutationCreateSensorDeviceArgs = {
  device: DeviceInput;
};


export type MutationCreateSetArgs = {
  set: SetInput;
};


export type MutationCreateUserArgs = {
  user: UserInput;
};


export type MutationCreateVaeConfigArgs = {
  deviceId: Scalars['ID'];
  engine: Scalars['String'];
  name: Scalars['String'];
};


export type MutationCreateZoneArgs = {
  zone: ZoneInput;
};


export type MutationDeleteDeviceArgs = {
  id: Scalars['ID'];
};


export type MutationDeleteGroupArgs = {
  id: Scalars['ID'];
};


export type MutationDeleteHierarchyArgs = {
  id: Scalars['ID'];
};


export type MutationDeleteImageMapLayerArgs = {
  layerId: Scalars['ID'];
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationDeleteImageMapObjectArgs = {
  objectId: Scalars['ID'];
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationDeleteImageMapSetArgs = {
  setId: Scalars['ID'];
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationDeleteLabelArgs = {
  id: Scalars['ID'];
};


export type MutationDeletePolicyArgs = {
  id: Scalars['ID'];
};


export type MutationDeletePolicyStatementArgs = {
  statementId: Scalars['ID'];
};


export type MutationDeleteSetArgs = {
  id: Scalars['ID'];
};


export type MutationDeleteSubscriptionArgs = {
  id: Scalars['String'];
};


export type MutationDeleteUserArgs = {
  id: Scalars['ID'];
};


export type MutationDeleteVaeConfigArgs = {
  deviceId: Scalars['ID'];
  engine: Scalars['String'];
  name: Scalars['String'];
};


export type MutationDeleteZoneArgs = {
  id: Scalars['ID'];
};


export type MutationDeviceCommandArgs = {
  command: DeviceCommand;
  id: Scalars['ID'];
};


export type MutationEventsAcknowledgementArgs = {
  entries: Array<AcknowledgementEntry>;
};


export type MutationInsertHierarchyArgs = {
  hierarchy: HierarchyInput;
};


export type MutationInsertImageMapLayerArgs = {
  layer: ImageMapLayerInput;
  setId: Scalars['ID'];
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationInsertImageMapObjectArgs = {
  mapId: Scalars['ID'];
  object: ImageMapObjectInput;
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationInsertImageMapSetArgs = {
  set: ImageMapSetInput;
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationInsertLabelsArgs = {
  labels: Array<LabelInput>;
};


export type MutationModifySubscriptionArgs = {
  realmSubscription: RealmSubscriptionInput;
};


export type MutationPtzPresetArgs = {
  id: Scalars['ID'];
  input: Ptz_PresetInput;
  priority?: InputMaybe<Scalars['Int']>;
};


export type MutationPtzRelArgs = {
  id: Scalars['ID'];
  input: Ptz_RelInput;
  priority?: InputMaybe<Scalars['Int']>;
};


export type MutationPtzSpeedArgs = {
  id: Scalars['ID'];
  input: Ptz_SpeedInput;
  priority?: InputMaybe<Scalars['Int']>;
};


export type MutationPtzStepArgs = {
  id: Scalars['ID'];
  input: Ptz_StepInput;
  priority?: InputMaybe<Scalars['Int']>;
};


export type MutationPurgeAvatarQueueArgs = {
  id: Scalars['ID'];
};


export type MutationRegenerateAvatarApiKeyArgs = {
  id: Scalars['ID'];
};


export type MutationRemoveAvatarApiKeyArgs = {
  id: Scalars['ID'];
};


export type MutationRemoveLabelsArgs = {
  ids: Array<Scalars['ID']>;
  objectId: Scalars['ID'];
};


export type MutationRenameImageMapLayerArgs = {
  layerId: Scalars['ID'];
  name: Scalars['String'];
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationRenameImageMapSetArgs = {
  name: Scalars['String'];
  setId: Scalars['ID'];
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationRenameVaeConfigArgs = {
  deviceId: Scalars['ID'];
  engine: Scalars['String'];
  name: Scalars['String'];
  newName: Scalars['String'];
};


export type MutationSetPasswordArgs = {
  input: SetPasswordInput;
};


export type MutationSetUserRealmArgs = {
  realmId: Scalars['ID'];
  userName: Scalars['String'];
};


export type MutationUnblockUserArgs = {
  id: Scalars['ID'];
};


export type MutationUpdateCurrentRealmArgs = {
  realm: CurrentRealmInput;
};


export type MutationUpdateDeviceArgs = {
  device: DeviceInput;
  id: Scalars['ID'];
};


export type MutationUpdateGeoLayersArgs = {
  input: GeoLayersInput;
};


export type MutationUpdateGroupArgs = {
  group: GroupInput;
  id: Scalars['ID'];
};


export type MutationUpdateHierarchyArgs = {
  hierarchy: HierarchyInput;
};


export type MutationUpdateImageMapArgs = {
  map: ImageMapInput;
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationUpdateImageMapLayerArgs = {
  layer: ImageMapLayerInput;
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationUpdateImageMapObjectArgs = {
  object: ImageMapObjectInput;
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationUpdateImageMapSetArgs = {
  set: ImageMapSetInput;
  updateId: Scalars['ID'];
  version: Scalars['String'];
};


export type MutationUpdateLabelArgs = {
  label: LabelInput;
};


export type MutationUpdatePolicyArgs = {
  id: Scalars['ID'];
  policy: PolicyInput;
};


export type MutationUpdatePolicyStatementArgs = {
  statement: PolicyStatementInput;
  statementId: Scalars['ID'];
};


export type MutationUpdatePositionArgs = {
  id: Scalars['ID'];
  position: LatLngInput;
};


export type MutationUpdateRealmArgs = {
  realmInput: RealmInput;
};


export type MutationUpdateSetArgs = {
  id: Scalars['ID'];
  set: SetInput;
};


export type MutationUpdateSolidConfigArgs = {
  solidConfig?: InputMaybe<Scalars['String']>;
  userId: Scalars['ID'];
};


export type MutationUpdateSolidConfigCurrentViewArgs = {
  input: SolidConfigCurrentViewInput;
};


export type MutationUpdateUserArgs = {
  id: Scalars['ID'];
  user: UserInput;
};


export type MutationUpdateZoneArgs = {
  id: Scalars['ID'];
  zone: ZoneInput;
};


export type MutationValidateAddSubscriptionArgs = {
  realmSubscription: RealmSubscriptionInput;
};


export type MutationValidateEmailArgs = {
  addresses: EmailAddresses;
};


export type MutationValidateModifySubscriptionArgs = {
  realmSubscription: RealmSubscriptionInput;
};

export type NetworkConnectDescriptor = {
  __typename?: 'NetworkConnectDescriptor';
  /** Complete URL to camera stream for URL config type */
  URL?: Maybe<Scalars['String']>;
  authType: AuthType;
  /** IP/host for ONVIF config type */
  host?: Maybe<Scalars['String']>;
  /** Password for ONVIF config type */
  pass?: Maybe<Scalars['String']>;
  /** HTTP port for ONVIF config type */
  port?: Maybe<Scalars['Int']>;
  /** Protocol for gateway */
  protocol?: Maybe<ProtocolType>;
  /** RTSP port for ONVIF config type */
  rtspPort?: Maybe<Scalars['Int']>;
  /** Username for ONVIF config type */
  user?: Maybe<Scalars['String']>;
};

export type NetworkConnectDescriptorInput = {
  URL?: InputMaybe<Scalars['String']>;
  authType: AuthType;
  host?: InputMaybe<Scalars['String']>;
  pass?: InputMaybe<Scalars['String']>;
  port?: InputMaybe<Scalars['Int']>;
  protocol?: InputMaybe<ProtocolType>;
  rtspPort?: InputMaybe<Scalars['Int']>;
  user?: InputMaybe<Scalars['String']>;
};

export type NumericReport = {
  __typename?: 'NumericReport';
  /**  Unix timestamp, sec  */
  time: Scalars['Int'];
  /**  Metric value  */
  value: Scalars['Float'];
};

export enum ObjectAction {
  AddLink = 'ADD_LINK',
  Create = 'CREATE',
  Delete = 'DELETE',
  RemoveLink = 'REMOVE_LINK',
  Status = 'STATUS',
  Update = 'UPDATE'
}

/** Object descriptor to provide access to basic object info only */
export type ObjectDescriptor = {
  __typename?: 'ObjectDescriptor';
  /** Object ID (UUID) */
  id: Scalars['ID'];
  isSystemManaged?: Maybe<Scalars['Boolean']>;
  /** Object name */
  name: Scalars['String'];
  type: RealmObjectType;
};

export type ObjectUpdateEvent = {
  __typename?: 'ObjectUpdateEvent';
  action: ObjectAction;
  childObjects?: Maybe<Array<Scalars['ID']>>;
  healthStatus?: Maybe<HealthStatus>;
  id: Scalars['ID'];
  realmId: Scalars['ID'];
  systemStatus?: Maybe<SystemStatus>;
  time: Scalars['Float'];
  type: Scalars['String'];
};

export type ObjectUpdateFilter = {
  actions?: InputMaybe<Array<ObjectAction>>;
  type?: InputMaybe<Scalars['String']>;
};

export type Owner = {
  __typename?: 'Owner';
  createdAt: Scalars['DateTime'];
  displayName: Scalars['String'];
  email?: Maybe<Scalars['String']>;
  id: Scalars['ID'];
  updatedAt: Scalars['DateTime'];
};

export type OwnerInput = {
  displayName: Scalars['String'];
  email?: InputMaybe<Scalars['String']>;
  id?: InputMaybe<Scalars['ID']>;
  password?: InputMaybe<Scalars['String']>;
};

export enum Ptz_Class {
  /**  Support for absolute positioning in camera-mount-relative system of coordinates  */
  PtzAbsolute = 'PTZ_ABSOLUTE',
  /**  Continuous and speed controls  */
  PtzContinous = 'PTZ_CONTINOUS',
  /**  Click-On-Screen  */
  PtzCos = 'PTZ_COS',
  /**  Support for absolute positioning in geo-coordinates  */
  PtzGeoAbsolute = 'PTZ_GEO_ABSOLUTE',
  /**  PTZ Presents support  */
  PtzPresets = 'PTZ_PRESETS',
  /**  Step controls  */
  PtzStep = 'PTZ_STEP'
}

/**  will be executed first method  */
export type Ptz_PresetInput = {
  /**  Delete preset position, 1..100  */
  clear?: InputMaybe<Scalars['Int']>;
  /**  Goto preset position, 1..100  */
  goto?: InputMaybe<Scalars['Int']>;
  /**  Save current position, 1..100  */
  save?: InputMaybe<Scalars['Int']>;
};

export type Ptz_RelInput = {
  /**  Video resolution  */
  size: Ptz_RelSizeInput;
  /**  Center camera to x,y position (based on video resolution)  */
  xy: Array<Scalars['Int']>;
};

export type Ptz_RelSizeInput = {
  height: Scalars['Int'];
  width: Scalars['Int'];
};

/**  will be executed first method  */
export type Ptz_SpeedInput = {
  /**  Focus with speed, -100...100  */
  focus?: InputMaybe<Scalars['Int']>;
  /**  Gain with speed, -100...100  */
  gain?: InputMaybe<Scalars['Int']>;
  /**  Iris with speed, -100...100  */
  iris?: InputMaybe<Scalars['Int']>;
  /**  Move with speeds for pan and tilt, [-100..100,-100..100]. ex: [10, 30]  */
  pt?: InputMaybe<Array<Scalars['Int']>>;
  /**  Zoom in/out with speed, -100...100  */
  z?: InputMaybe<Scalars['Int']>;
};

export enum Ptz_StepFocus {
  Far = 'far',
  Near = 'near'
}

export enum Ptz_StepGain {
  Down = 'down',
  Up = 'up'
}

/**  will be executed first method  */
export type Ptz_StepInput = {
  focus?: InputMaybe<Ptz_StepFocus>;
  gain?: InputMaybe<Ptz_StepGain>;
  iris?: InputMaybe<Ptz_StepIris>;
  move?: InputMaybe<Ptz_StepMove>;
  zoom?: InputMaybe<Ptz_StepZoom>;
};

export enum Ptz_StepIris {
  Close = 'close',
  Open = 'open'
}

/**  Do one step in specific direction  */
export enum Ptz_StepMove {
  Down = 'down',
  Downleft = 'downleft',
  Downright = 'downright',
  Left = 'left',
  Right = 'right',
  Up = 'up',
  Upleft = 'upleft',
  Upright = 'upright'
}

export enum Ptz_StepZoom {
  In = 'in',
  Out = 'out'
}

export type Policy = RealmObject & {
  __typename?: 'Policy';
  createdAt?: Maybe<Scalars['DateTime']>;
  groups: Array<Group>;
  id: Scalars['ID'];
  isSystemManaged: Scalars['Boolean'];
  modifiedAt?: Maybe<Scalars['DateTime']>;
  name: Scalars['String'];
  statements: Array<PolicyStatement>;
  type: RealmObjectType;
};

export type PolicyInput = {
  addToGroupIds?: InputMaybe<Array<Scalars['ID']>>;
  name?: InputMaybe<Scalars['String']>;
  removeFromGroupIds?: InputMaybe<Array<Scalars['ID']>>;
};

export type PolicyStatement = {
  __typename?: 'PolicyStatement';
  actions: Array<Scalars['String']>;
  allResources: Scalars['Boolean'];
  effect: StatementEffect;
  id: Scalars['ID'];
  name: Scalars['String'];
  resources: Array<ObjectDescriptor>;
};

export type PolicyStatementInput = {
  actions?: InputMaybe<Array<Scalars['String']>>;
  addResourceIds?: InputMaybe<Array<Scalars['ID']>>;
  allResources?: InputMaybe<Scalars['Boolean']>;
  effect?: InputMaybe<StatementEffect>;
  name?: InputMaybe<Scalars['String']>;
  removeResourceIds?: InputMaybe<Array<Scalars['ID']>>;
};

export type PoolLocalStorage = {
  __typename?: 'PoolLocalStorage';
  enforce: Scalars['String'];
  path: Scalars['String'];
  size: Scalars['String'];
};

export type PoolLocalStorageInput = {
  enforce: Scalars['String'];
  path: Scalars['String'];
  size: Scalars['String'];
};

export type Position = {
  __typename?: 'Position';
  x: Scalars['Int'];
  y: Scalars['Int'];
};

export type PositionInput = {
  x: Scalars['Int'];
  y: Scalars['Int'];
};

export enum ProtocolType {
  Http = 'HTTP',
  Https = 'HTTPS'
}

export type Query = {
  __typename?: 'Query';
  /**  get list of access levels  */
  accessLevels: Array<AccessLevel>;
  /**  get list of actions  */
  actions: Array<Action>;
  /**  get AOD (Archive on Demand) requests by id  */
  aodGet: Array<AodRequest>;
  /**  get list AOD (Archive on Demand) requests  */
  aodGetList: Array<AodRequest>;
  /**  get list of updated AOD (Archive on Demand) requests  */
  aodGetUpdatedList: Array<AodRequest>;
  /**  get information about device archive coverage boundaries  */
  archiveBoundary: ArchiveBoundary;
  /**  get information about device archive coverage  */
  archiveCoverage: ArchiveCoverage;
  /**  get list of aspects templates  */
  aspectTemplates: Array<FunctionalAspectTemplate>;
  /**  get list of audit categories  */
  auditCategories: Array<AuditCategory>;
  /**  get list of audit events  */
  auditEntries: Array<AuditEntry>;
  /**  get list of avalilable features  */
  availableFeatures?: Maybe<Array<FeatureDesc>>;
  /**  Get a description and all possible metrics for avatar/link  */
  avatarMetrics: Array<AvatarMetric>;
  /**  Get the required avatar/link report  */
  avatarReport: Array<NumericReport>;
  /**  get camera log  */
  cameraLog: Array<CameraLog>;
  /**  Get a description and all possible metrics for current camera  */
  cameraMetrics: Array<CameraMetric>;
  /**  Get the required camera report  */
  cameraReport: Array<Report>;
  /**  get information about current realm  */
  currentRealm: CurrentRealm;
  /**  get device by id  */
  device?: Maybe<Device>;
  /**  get device functional aspects by aspect type  */
  deviceFunctionalAspectsByAspectTypes: Array<DeviceFunctionalAspect>;
  /**  get list of device templates  */
  deviceTemplates: Array<DeviceTemplate>;
  /**  get list of devices  */
  devices: Array<Device>;
  /**  get list of devices by aspect type  */
  devicesByAspectTypes: Array<Device>;
  /**  get list of devices by id  */
  devicesByIds: Array<Device>;
  /**  discover devices  */
  discoverDevices: Array<DeviceProbe>;
  /**  get stored geo layers  */
  geoLayers?: Maybe<GeoLayers>;
  /**  get group by id  */
  group?: Maybe<Group>;
  /**  get list of groups  */
  groups: Array<Group>;
  /**  get list guis  */
  guis: Array<Gui>;
  /**  get list of hierarchies  */
  hierarchies: Array<Hierarchy>;
  /**  get hierarchy by id  */
  hierarchy?: Maybe<Hierarchy>;
  /**  get image map config  */
  imageMapConfig: ImageMapConfig;
  /**  get image map image  */
  imageMapImage: Scalars['String'];
  /**  get label by id  */
  label?: Maybe<Label>;
  /**  get list of labels  */
  labels: Array<Label>;
  /**  get list of labels for object  */
  labelsForObject: Array<Label>;
  /**  get End User License Agreement  */
  license: License;
  /**  get config of local storage for avatar by id  */
  localStorage?: Maybe<LocalStorage>;
  /**  get list of policies  */
  policies: Array<Policy>;
  /**  get policy by id  */
  policy?: Maybe<Policy>;
  /**  probe device  */
  probeDevice: DeviceProbe;
  /**  get gateway devices and directories  */
  probeGateway: GatewayProbe;
  /**  get gateway directories  */
  probeGatewayDirectories: GatewayDirectoriesProbe;
  /**  probe sensor device  */
  probeSensorDevice: DeviceProbe;
  /**  get current realm  */
  realm?: Maybe<Realm>;
  /**  get realm object by id  */
  realmObject?: Maybe<RealmObject>;
  /**  get list of realm objects  */
  realmObjects: Array<RealmObject>;
  /**  get realm subscription by id  */
  realmSubscription: RealmSubscription;
  /**  get list of realm subscriptions  */
  realmSubscriptions?: Maybe<Array<RealmSubscription>>;
  /**  get server time  */
  serverTime: Scalars['DateTime'];
  /**  get set by id  */
  set?: Maybe<Set>;
  /**  get list of sets  */
  sets: Array<Set>;
  /**  SOLID config specific, not public  */
  solidConfig?: Maybe<Scalars['String']>;
  /**  get list of storage pools  */
  storagePools: Array<StoragePool>;
  /**  get state of used local storage space for avatar by id  */
  storageUsage?: Maybe<StorageUsage>;
  /**  get system status  */
  systemStatus: SystemStatusInfo;
  /**  get user by id  */
  user?: Maybe<User>;
  /**  get info about user */
  userInfo: UserInfo;
  /**  get list of user realms  */
  userRealms: Array<RealmObject>;
  /**  get list of users  */
  users: Array<User>;
  /**  get list of VAE configs for device with id  */
  vaeConfigs: Array<VaeConfigBrief>;
  /**  get list of VAE templates for device with id  */
  vaeTemplates: Array<FunctionalAspectTemplate>;
  /**  get zone by id  */
  zone?: Maybe<Zone>;
  /**  get list of zones  */
  zones: Array<Zone>;
};


export type QueryAodGetArgs = {
  endTime: Scalars['DateTime'];
  ids: Array<Scalars['ID']>;
  startTime: Scalars['DateTime'];
};


export type QueryAodGetListArgs = {
  endTime: Scalars['DateTime'];
  startTime: Scalars['DateTime'];
};


export type QueryAodGetUpdatedListArgs = {
  updatedFrom: Scalars['DateTime'];
};


export type QueryArchiveBoundaryArgs = {
  find: BoundaryFind;
  ids: Array<Scalars['ID']>;
  startTime: Scalars['DateTime'];
  streamNumbers: Array<Scalars['Int']>;
};


export type QueryArchiveCoverageArgs = {
  endTime: Scalars['DateTime'];
  ids: Array<Scalars['ID']>;
  startTime: Scalars['DateTime'];
};


export type QueryAuditEntriesArgs = {
  filter: AuditEntryFilter;
};


export type QueryAvatarReportArgs = {
  from: Scalars['DateTime'];
  id: Scalars['ID'];
  metricName: AvatarMetricName;
  to: Scalars['DateTime'];
};


export type QueryCameraLogArgs = {
  deviceId: Scalars['ID'];
};


export type QueryCameraMetricsArgs = {
  from?: InputMaybe<Scalars['DateTime']>;
  id: Scalars['ID'];
  to?: InputMaybe<Scalars['DateTime']>;
};


export type QueryCameraReportArgs = {
  dfaId: Scalars['Int'];
  from: Scalars['DateTime'];
  id: Scalars['ID'];
  metricName: CameraMetricName;
  to: Scalars['DateTime'];
};


export type QueryDeviceArgs = {
  id: Scalars['ID'];
};


export type QueryDeviceFunctionalAspectsByAspectTypesArgs = {
  types: Array<DeviceFunctionalAspectFilter>;
};


export type QueryDevicesByAspectTypesArgs = {
  types: Array<DeviceFunctionalAspectFilter>;
};


export type QueryDevicesByIdsArgs = {
  ids: Array<Scalars['ID']>;
};


export type QueryDiscoverDevicesArgs = {
  platformId: Scalars['ID'];
};


export type QueryGroupArgs = {
  id: Scalars['ID'];
};


export type QueryHierarchyArgs = {
  id: Scalars['ID'];
};


export type QueryImageMapConfigArgs = {
  lazyLoadImages?: InputMaybe<Scalars['Boolean']>;
  version: Scalars['String'];
};


export type QueryImageMapImageArgs = {
  mapId: Scalars['ID'];
  version: Scalars['String'];
};


export type QueryLabelArgs = {
  id: Scalars['ID'];
};


export type QueryLabelsForObjectArgs = {
  objectId: Scalars['ID'];
};


export type QueryLocalStorageArgs = {
  deviceId: Scalars['ID'];
};


export type QueryPolicyArgs = {
  id: Scalars['ID'];
};


export type QueryProbeDeviceArgs = {
  input: DeviceProbeInput;
};


export type QueryProbeGatewayArgs = {
  input: GatewayProbeInput;
};


export type QueryProbeGatewayDirectoriesArgs = {
  input: GatewayDirectoriesProbeInput;
};


export type QueryProbeSensorDeviceArgs = {
  input: DeviceProbeInput;
};


export type QueryRealmObjectArgs = {
  id: Scalars['ID'];
};


export type QueryRealmSubscriptionArgs = {
  adminLogin?: InputMaybe<Scalars['String']>;
  filter?: InputMaybe<Filter>;
  id?: InputMaybe<Scalars['ID']>;
};


export type QueryRealmSubscriptionsArgs = {
  filter?: InputMaybe<Filter>;
  limit?: InputMaybe<Scalars['Int']>;
  offset?: InputMaybe<Scalars['Int']>;
};


export type QuerySetArgs = {
  id: Scalars['ID'];
};


export type QuerySolidConfigArgs = {
  userId: Scalars['ID'];
};


export type QueryStorageUsageArgs = {
  deviceId: Scalars['ID'];
};


export type QueryUserArgs = {
  id: Scalars['ID'];
};


export type QueryVaeConfigsArgs = {
  deviceId: Scalars['ID'];
  engine: Scalars['String'];
};


export type QueryVaeTemplatesArgs = {
  deviceId: Scalars['ID'];
};


export type QueryZoneArgs = {
  id: Scalars['ID'];
};

/** Realm base type */
export type Realm = {
  __typename?: 'Realm';
  adminEmail?: Maybe<Scalars['String']>;
  auditTtl?: Maybe<Scalars['String']>;
  avatarLocalStreaming?: Maybe<Scalars['Boolean']>;
  createdAt?: Maybe<Scalars['DateTime']>;
  emailAuth?: Maybe<EmailAuth>;
  emailEnabled?: Maybe<Scalars['Boolean']>;
  emailFrom?: Maybe<Scalars['String']>;
  emailHost?: Maybe<Scalars['String']>;
  emailPass?: Maybe<Scalars['String']>;
  emailPort?: Maybe<Scalars['Int']>;
  emailTls?: Maybe<Scalars['Boolean']>;
  emailUser?: Maybe<Scalars['String']>;
  emailValidated?: Maybe<Scalars['Boolean']>;
  id: Scalars['ID'];
  jitterBufferLength?: Maybe<Scalars['Int']>;
  /**  realm settings  */
  maxDownloadTime?: Maybe<Scalars['Int']>;
  maxScheduledDeliveryDelay?: Maybe<Scalars['Int']>;
  maxVideoPlayers?: Maybe<Scalars['Int']>;
  mfAuth?: Maybe<Scalars['Boolean']>;
  name: Scalars['String'];
  playerIdleTimeout?: Maybe<Scalars['Int']>;
  realmObjects?: Maybe<Array<RealmObject>>;
  resellerParent?: Maybe<Reseller>;
  updatedAt?: Maybe<Scalars['DateTime']>;
  warnVideoPlayers?: Maybe<Scalars['Int']>;
};

export type RealmInput = {
  adminEmail?: InputMaybe<Scalars['String']>;
  auditTtl?: InputMaybe<Scalars['String']>;
  avatarLocalStreaming?: InputMaybe<Scalars['Boolean']>;
  emailAuth?: InputMaybe<EmailAuth>;
  emailEnabled?: InputMaybe<Scalars['Boolean']>;
  emailFrom?: InputMaybe<Scalars['String']>;
  emailHost?: InputMaybe<Scalars['String']>;
  emailPass?: InputMaybe<Scalars['String']>;
  emailPort?: InputMaybe<Scalars['Int']>;
  emailTls?: InputMaybe<Scalars['Boolean']>;
  emailUser?: InputMaybe<Scalars['String']>;
  emailValidated?: InputMaybe<Scalars['Boolean']>;
  id: Scalars['ID'];
  jitterBufferLength?: InputMaybe<Scalars['Int']>;
  maxDownloadTime?: InputMaybe<Scalars['Int']>;
  maxScheduledDeliveryDelay?: InputMaybe<Scalars['Int']>;
  maxVideoPlayers?: InputMaybe<Scalars['Int']>;
  mfAuth?: InputMaybe<Scalars['Boolean']>;
  name: Scalars['String'];
  playerIdleTimeout?: InputMaybe<Scalars['Int']>;
  warnVideoPlayers?: InputMaybe<Scalars['Int']>;
};

export type RealmObject = {
  createdAt?: Maybe<Scalars['DateTime']>;
  /** Object ID (UUID) */
  id: Scalars['ID'];
  modifiedAt?: Maybe<Scalars['DateTime']>;
  /** Object name */
  name: Scalars['String'];
  type: RealmObjectType;
};

export enum RealmObjectType {
  Device = 'DEVICE',
  Group = 'GROUP',
  /** Generic Realm object */
  Object = 'OBJECT',
  Policy = 'POLICY',
  /** Realm */
  Realm = 'REALM',
  Set = 'SET',
  Statement = 'STATEMENT',
  User = 'USER',
  Zone = 'ZONE'
}

/**
 * This the customer's Subscription object
 *
 * Extracted from the Realm object to its own thing
 */
export type RealmSubscription = {
  __typename?: 'RealmSubscription';
  createdAt: Scalars['DateTime'];
  features: Array<Feature>;
  id: Scalars['ID'];
  owner: Owner;
  periodExpiresAt: Scalars['DateTime'];
  periodStartedAt: Scalars['DateTime'];
  simpleui?: Maybe<Scalars['Boolean']>;
  status: SubscriptionStatus;
  storagePools: Array<SubStoragePool>;
  title: Scalars['String'];
  type?: Maybe<RealmSubscriptionType>;
  updatedAt: Scalars['DateTime'];
};

export type RealmSubscriptionInput = {
  features?: InputMaybe<Array<FeatureInput>>;
  id?: InputMaybe<Scalars['ID']>;
  owner?: InputMaybe<OwnerInput>;
  periodExpiresAt?: InputMaybe<Scalars['DateTime']>;
  periodStartedAt?: InputMaybe<Scalars['DateTime']>;
  simpleui?: InputMaybe<Scalars['Boolean']>;
  storagePools?: InputMaybe<Array<SubStoragePoolInput>>;
  title?: InputMaybe<Scalars['String']>;
  type?: InputMaybe<RealmSubscriptionType>;
};

export enum RealmSubscriptionType {
  Production = 'production',
  SelfManaged = 'self_managed'
}

export type Report = NumericReport | StatusReport;

/**
 * extend type User {
 *     resellerDomains: [Reseller!]!
 * }
 */
export type Reseller = {
  __typename?: 'Reseller';
  brandInfo?: Maybe<BrandInfo>;
  children: Array<Reseller>;
  createdAt?: Maybe<Scalars['DateTime']>;
  displayName: Scalars['String'];
  id: Scalars['ID'];
  name: Scalars['String'];
  owner?: Maybe<User>;
  parent?: Maybe<Reseller>;
  realms: Array<Realm>;
  updatedAt?: Maybe<Scalars['DateTime']>;
};

export type SensorEvent = {
  __typename?: 'SensorEvent';
  description: Scalars['String'];
  type: Scalars['String'];
};

export type SensorEventInput = {
  description: Scalars['String'];
  type: Scalars['String'];
};

export type SessionCloseEvent = {
  __typename?: 'SessionCloseEvent';
  reason: SessionCloseReason;
  sessionId: Scalars['String'];
};

export enum SessionCloseReason {
  SessionExpired = 'SESSION_EXPIRED',
  SessionTerminated = 'SESSION_TERMINATED'
}

export type Set = RealmObject & {
  __typename?: 'Set';
  createdAt?: Maybe<Scalars['DateTime']>;
  devices: Array<ObjectDescriptor>;
  id: Scalars['ID'];
  isSystemManaged: Scalars['Boolean'];
  modifiedAt?: Maybe<Scalars['DateTime']>;
  name: Scalars['String'];
  type: RealmObjectType;
};

export type SetInput = {
  addDeviceIds?: InputMaybe<Array<Scalars['ID']>>;
  name?: InputMaybe<Scalars['String']>;
  removeDeviceIds?: InputMaybe<Array<Scalars['ID']>>;
};

export type SetPasswordInput = {
  newPassword: Scalars['String'];
  userId: Scalars['ID'];
};

export type SharedViewsUpdateEvent = {
  __typename?: 'SharedViewsUpdateEvent';
  modifiedBy: ModifiedByInfo;
  sharedViews?: Maybe<Scalars['String']>;
};

export type SoftwareInfo = {
  __typename?: 'SoftwareInfo';
  lastUpdateSucceeded?: Maybe<Scalars['Boolean']>;
  lastUpdateTime?: Maybe<Scalars['DateTime']>;
  updateAvailable?: Maybe<Scalars['Boolean']>;
  version?: Maybe<Scalars['String']>;
};

/**  SOLID config specific  */
export type SolidConfigCurrentViewInput = {
  currentViewId?: InputMaybe<Scalars['String']>;
  recentViewIds?: InputMaybe<Array<Scalars['String']>>;
  userId: Scalars['ID'];
  version: Scalars['String'];
  windowProps?: InputMaybe<Scalars['JSON']>;
};

export type SolidConfigUpdateEvent = {
  __typename?: 'SolidConfigUpdateEvent';
  solidConfig?: Maybe<Scalars['String']>;
  userId: Scalars['ID'];
};

/**  If array is empty we should not make any limitation  */
export type SolidConfiguration = {
  __typename?: 'SolidConfiguration';
  activities: Array<ActivityId>;
  config: Scalars['JSON'];
  views: Array<ViewConfig>;
  widgets: Array<WidgetConfig>;
};

export type StatTime = {
  __typename?: 'StatTime';
  avg: Scalars['Float'];
  max: Scalars['Float'];
  min: Scalars['Float'];
};

export enum StatementEffect {
  Allow = 'ALLOW',
  Deny = 'DENY'
}

export enum StatusMetric {
  Degraded = 'DEGRADED',
  Disabled = 'DISABLED',
  Offline = 'OFFLINE',
  Online = 'ONLINE',
  Warnings = 'WARNINGS'
}

export type StatusReport = {
  __typename?: 'StatusReport';
  /**  Status unix timestamp, sec  */
  time: Scalars['Int'];
  /**  Status metric value  */
  value: StatusMetric;
};

export type StoragePool = {
  __typename?: 'StoragePool';
  id: Scalars['ID'];
  name: Scalars['String'];
  ttlHours: Scalars['Int'];
};

export type StorageUsage = {
  __typename?: 'StorageUsage';
  free?: Maybe<Scalars['Float']>;
  localStorageVolume?: Maybe<Scalars['Float']>;
  requiredVolume?: Maybe<Scalars['Float']>;
};

export type StreamShare = {
  __typename?: 'StreamShare';
  error?: Maybe<Scalars['String']>;
  id: Scalars['Int'];
  status?: Maybe<HealthStatus>;
  url: Scalars['String'];
};

export type StreamUsagePeriod = {
  from: Scalars['DateTime'];
  to: Scalars['DateTime'];
};

export type SubStoragePool = {
  __typename?: 'SubStoragePool';
  features: Array<Feature>;
  id: Scalars['ID'];
  name: Scalars['String'];
  /** Duration in hours */
  ttlHrs: Scalars['Int'];
};

export type SubStoragePoolInput = {
  features: Array<FeatureInput>;
  id?: InputMaybe<Scalars['ID']>;
  name: Scalars['String'];
  /** Duration in hours */
  ttlHrs: Scalars['Int'];
};

export type SubscribedGatewayEventInput = {
  id: Scalars['ID'];
  type: Scalars['String'];
};

export type Subscription = {
  __typename?: 'Subscription';
  aodUpdate?: Maybe<Array<AodRequest>>;
  /**  subscribe to new audit events  */
  auditEntries: AuditEntryEvent;
  /**  subscribe to hierarchies for updates  */
  hierarchyUpdate: LabelOrHierarchyUpdate;
  /**  subscribe to image map for updates  */
  imageMapUpdate: ImageMapUpdateNotification;
  /**  subscribe to labels for updates  */
  labelUpdate: LabelOrHierarchyUpdate;
  /**  internal use only, subscribe to object updates  */
  objectUpdate: ObjectUpdateEvent;
  /**  internal use only, subscribe for session close  */
  sessionClose: SessionCloseEvent;
  /**  internal use only, subscribe to shared view updates  */
  sharedViewsUpdate: SharedViewsUpdateEvent;
  /**  SOLID config specific, not public  */
  solidConfigUpdate: SolidConfigUpdateEvent;
};


export type SubscriptionAodUpdateArgs = {
  filter: AodRequestFilter;
};


export type SubscriptionAuditEntriesArgs = {
  filter: AuditEntryFilter;
};


export type SubscriptionImageMapUpdateArgs = {
  version: Scalars['String'];
};


export type SubscriptionObjectUpdateArgs = {
  filter?: InputMaybe<ObjectUpdateFilter>;
};

export enum SubscriptionStatus {
  Active = 'ACTIVE',
  Hibernate = 'HIBERNATE'
}

export enum SystemStatus {
  Alert = 'ALERT',
  Broken = 'BROKEN',
  Critical = 'CRITICAL',
  Offline = 'OFFLINE',
  Online = 'ONLINE',
  Starting = 'STARTING',
  Stopping = 'STOPPING'
}

export type SystemStatusInfo = {
  __typename?: 'SystemStatusInfo';
  description?: Maybe<Scalars['String']>;
  reasons: Array<SystemStatusReason>;
  status: SystemStatus;
};

export type SystemStatusReason = {
  __typename?: 'SystemStatusReason';
  message: Scalars['String'];
  object?: Maybe<SystemStatusReasonObject>;
};

export type SystemStatusReasonObject = {
  __typename?: 'SystemStatusReasonObject';
  /** Object ID (UUID) */
  id: Scalars['ID'];
  /** Object name */
  name: Scalars['String'];
  type: Scalars['String'];
};

export enum UnitType {
  Gb = 'Gb',
  Unit = 'Unit'
}

export type UpdateResult = {
  __typename?: 'UpdateResult';
  updated: Scalars['Boolean'];
  warning?: Maybe<Scalars['String']>;
  warningFields?: Maybe<Array<WarningField>>;
};

export type User = RealmObject & {
  __typename?: 'User';
  createdAt?: Maybe<Scalars['DateTime']>;
  email?: Maybe<Scalars['String']>;
  emailConfirmed?: Maybe<Scalars['Boolean']>;
  groups: Array<Group>;
  id: Scalars['ID'];
  loggedOnAt?: Maybe<Scalars['DateTime']>;
  modifiedAt?: Maybe<Scalars['DateTime']>;
  name: Scalars['String'];
  sendNotification?: Maybe<Scalars['Boolean']>;
  type: RealmObjectType;
};

export type UserData = {
  __typename?: 'UserData';
  id: Scalars['String'];
  isAdmin: Scalars['Boolean'];
  name: Scalars['String'];
  solidConfiguration: SolidConfiguration;
};

export type UserInfo = {
  __typename?: 'UserInfo';
  realm: CurrentRealm;
  user: UserData;
};

export type UserInput = {
  addToGroupIds?: InputMaybe<Array<Scalars['ID']>>;
  confirmPassword?: InputMaybe<Scalars['String']>;
  email?: InputMaybe<Scalars['String']>;
  name?: InputMaybe<Scalars['String']>;
  password?: InputMaybe<Scalars['String']>;
  removeFromGroupIds?: InputMaybe<Array<Scalars['ID']>>;
  sendNotification?: InputMaybe<Scalars['Boolean']>;
};

export enum VmxVideoStreamingMode {
  Auto = 'AUTO',
  Local = 'LOCAL'
}

export type VaeConfigBrief = {
  __typename?: 'VaeConfigBrief';
  description: Scalars['String'];
  name: Scalars['String'];
};

export type VaeConfigFull = {
  __typename?: 'VaeConfigFull';
  configuration: Scalars['JSONObject'];
  description: Scalars['String'];
  name: Scalars['String'];
};

export type VaeFeature = {
  __typename?: 'VaeFeature';
  exclusive?: Maybe<Scalars['Boolean']>;
  id: Scalars['String'];
  name: Scalars['String'];
  order: Scalars['Int'];
};

export type VaeUpdate = {
  __typename?: 'VaeUpdate';
  log?: Maybe<Array<Scalars['String']>>;
  name: Scalars['String'];
  status: VaeUpdateStatus;
  version?: Maybe<Scalars['String']>;
};

export enum VaeUpdateStatus {
  Error = 'ERROR',
  Ok = 'OK'
}

export type ViewConfig = {
  __typename?: 'ViewConfig';
  config: Scalars['JSON'];
  viewId: ViewId;
};

export enum ViewId {
  AvatarActivation = 'AvatarActivation',
  Avatars = 'Avatars',
  Cameras = 'Cameras',
  DeviceAudit = 'DeviceAudit',
  EditMap = 'EditMap',
  Gateways = 'Gateways',
  Groups = 'Groups',
  Hierarchy = 'Hierarchy',
  Labels = 'Labels',
  LinkProvision = 'LinkProvision',
  ManageAvatars = 'ManageAvatars',
  ManageAvatarsFacial = 'ManageAvatarsFacial',
  ManageAvatarsLpr = 'ManageAvatarsLPR',
  NotificationPolicies = 'NotificationPolicies',
  Policies = 'Policies',
  QuickStart = 'QuickStart',
  RealmSettings = 'RealmSettings',
  Reports = 'Reports',
  Sensors = 'Sensors',
  Sets = 'Sets',
  Subscription = 'Subscription',
  TrainingVideos = 'TrainingVideos',
  UserAudit = 'UserAudit',
  Users = 'Users',
  VideoWalls = 'VideoWalls',
  Zones = 'Zones'
}

export type WarningField = {
  __typename?: 'WarningField';
  field?: Maybe<Scalars['String']>;
  value?: Maybe<Scalars['String']>;
};

export type WidgetConfig = {
  __typename?: 'WidgetConfig';
  config: Scalars['JSON'];
  widgetId: WidgetId;
};

export enum WidgetId {
  AdminAvatars = 'AdminAvatars',
  AdminDevices = 'AdminDevices',
  AdminGateways = 'AdminGateways',
  AdminSensors = 'AdminSensors',
  ArchiveEventList = 'ArchiveEventList',
  ArchiveViewer = 'ArchiveViewer',
  AvatarProvision = 'AvatarProvision',
  CameraLive = 'CameraLive',
  DeviceList = 'DeviceList',
  DownloadManager = 'DownloadManager',
  EventDetails = 'EventDetails',
  EventList = 'EventList',
  EventVideo = 'EventVideo',
  GeoMap = 'GeoMap',
  Groups = 'Groups',
  HierarchyEdit = 'HierarchyEdit',
  ImageMap = 'ImageMap',
  LabelEdit = 'LabelEdit',
  LinkProvision = 'LinkProvision',
  ManageAvatars = 'ManageAvatars',
  NotificationPolicies = 'NotificationPolicies',
  Policies = 'Policies',
  QuickStart = 'QuickStart',
  RealmSettings = 'RealmSettings',
  Reports = 'Reports',
  Sets = 'Sets',
  Subscription = 'Subscription',
  Timeline = 'Timeline',
  TrainingVideos = 'TrainingVideos',
  Users = 'Users',
  VideoTouring = 'VideoTouring',
  VideoWalls = 'VideoWalls',
  Vmx = 'Vmx',
  WatchlistFacial = 'WatchlistFacial',
  WatchlistLpr = 'WatchlistLPR',
  Zones = 'Zones'
}

export type Zone = RealmObject & {
  __typename?: 'Zone';
  createdAt?: Maybe<Scalars['DateTime']>;
  devices: Array<ObjectDescriptor>;
  id: Scalars['ID'];
  modifiedAt?: Maybe<Scalars['DateTime']>;
  name: Scalars['String'];
  type: RealmObjectType;
};

export type ZoneInput = {
  addDeviceIds?: InputMaybe<Array<Scalars['ID']>>;
  name?: InputMaybe<Scalars['String']>;
  removeDeviceIds?: InputMaybe<Array<Scalars['ID']>>;
};

export type DeviceFieldsFragment = { __typename?: 'Device', id: string, name: string, createdAt?: Date | null, modifiedAt?: Date | null, enabled: boolean, healthStatus: HealthStatus, version: string, location?: string | null, deliveryPriority?: number | null, eventType?: DeviceEventType | null, rtpOverTcp?: boolean | null, rtpTime?: boolean | null, deviceType?: BaseDeviceType | null, position?: { __typename?: 'LatLng', lat: number, lng: number, alt?: number | null } | null, config: { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } }, platform?: { __typename?: 'Device', id: string, name: string, aspects: Array<{ __typename?: 'DFA_Avatar', webRtcEnabled?: boolean | null, type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Media', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType }> } | null, zone?: { __typename?: 'ObjectDescriptor', id: string, name: string } | null, set?: Array<{ __typename?: 'ObjectDescriptor', id: string, name: string, isSystemManaged?: boolean | null }> | null, storageConfig?: { __typename?: 'DeviceStorageConfig', storagePool: { __typename?: 'StoragePool', id: string, name: string, ttlHours: number } } | null, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> }> };

export type StatTimeFieldsFragment = { __typename?: 'StatTime', avg: number, max: number, min: number };

export type DevicePlayerFieldsFragment = { __typename?: 'Device', id: string, name: string, cloudDirect: boolean, aspects: Array<{ __typename?: 'DFA_Avatar', enabled: boolean } | { __typename?: 'DFA_Gateway', enabled: boolean } | { __typename?: 'DFA_Media', streamType: MediaStreamType, enabled: boolean } | { __typename?: 'DFA_PTZ', enabled: boolean } | { __typename?: 'DFA_Sensor', enabled: boolean } | { __typename?: 'DFA_VAE', enabled: boolean }>, platform?: { __typename?: 'Device', aspects: Array<{ __typename?: 'DFA_Avatar', webRtcEnabled?: boolean | null } | { __typename?: 'DFA_Gateway' } | { __typename?: 'DFA_Media' } | { __typename?: 'DFA_PTZ' } | { __typename?: 'DFA_Sensor' } | { __typename?: 'DFA_VAE' }> } | null };

export type SetsFieldsFragment = { __typename?: 'ObjectDescriptor', id: string, name: string, isSystemManaged?: boolean | null };

export type ConnectFieldsFragment = { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null };

export type DeviceConfigFieldsFragment = { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } };

export type StorageConfigFieldsFragment = { __typename?: 'DeviceStorageConfig', storagePool: { __typename?: 'StoragePool', id: string, name: string, ttlHours: number } };

export type StoragePoolFieldsFragment = { __typename?: 'StoragePool', id: string, name: string, ttlHours: number };

type AspectFields_Dfa_Avatar_Fragment = { __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> };

type AspectFields_Dfa_Gateway_Fragment = { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> };

type AspectFields_Dfa_Media_Fragment = { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> };

type AspectFields_Dfa_Ptz_Fragment = { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> };

type AspectFields_Dfa_Sensor_Fragment = { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> };

type AspectFields_Dfa_Vae_Fragment = { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> };

export type AspectFieldsFragment = AspectFields_Dfa_Avatar_Fragment | AspectFields_Dfa_Gateway_Fragment | AspectFields_Dfa_Media_Fragment | AspectFields_Dfa_Ptz_Fragment | AspectFields_Dfa_Sensor_Fragment | AspectFields_Dfa_Vae_Fragment;

export type AspectHealthFieldsFragment = { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus };

export type AspectTemplateFieldsFragment = { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null };

export type DeviceProbeFieldsFragment = { __typename?: 'DeviceProbe', name?: string | null, snapshots: Array<string>, rtpTime?: boolean | null, config: { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } }, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> }> };

export type LocalStorageFieldsFragment = { __typename?: 'LocalStorage', enabled: boolean, strategy: string, ver: string, pool: { __typename?: 'PoolLocalStorage', path: string, size: string, enforce: string } };

export type GetDeviceSharedStreamQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type GetDeviceSharedStreamQuery = { __typename?: 'Query', device?: { __typename?: 'Device', aspects: Array<{ __typename?: 'DFA_Avatar' } | { __typename?: 'DFA_Gateway' } | { __typename?: 'DFA_Media', sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, status?: HealthStatus | null, error?: string | null }> | null } | { __typename?: 'DFA_PTZ' } | { __typename?: 'DFA_Sensor' } | { __typename?: 'DFA_VAE' }> } | null };

export type GetLocalStorageConfigQueryVariables = Exact<{
  deviceId: Scalars['ID'];
}>;


export type GetLocalStorageConfigQuery = { __typename?: 'Query', localStorage?: { __typename?: 'LocalStorage', enabled: boolean, strategy: string, ver: string, pool: { __typename?: 'PoolLocalStorage', path: string, size: string, enforce: string } } | null };

export type DeviceListFieldsFragment = { __typename?: 'Device', id: string, name: string, enabled: boolean, healthStatus: HealthStatus, deviceType?: BaseDeviceType | null };

export type DeviceListByAspectTypesQueryVariables = Exact<{
  types: Array<DeviceFunctionalAspectFilter> | DeviceFunctionalAspectFilter;
}>;


export type DeviceListByAspectTypesQuery = { __typename?: 'Query', devicesByAspectTypes: Array<{ __typename?: 'Device', id: string, name: string, enabled: boolean, healthStatus: HealthStatus, deviceType?: BaseDeviceType | null }> };

export type DevicesByAspectTypesQueryVariables = Exact<{
  types: Array<DeviceFunctionalAspectFilter> | DeviceFunctionalAspectFilter;
}>;


export type DevicesByAspectTypesQuery = { __typename?: 'Query', devicesByAspectTypes: Array<{ __typename?: 'Device', id: string, name: string, createdAt?: Date | null, modifiedAt?: Date | null, enabled: boolean, healthStatus: HealthStatus, version: string, location?: string | null, deliveryPriority?: number | null, eventType?: DeviceEventType | null, rtpOverTcp?: boolean | null, rtpTime?: boolean | null, deviceType?: BaseDeviceType | null, position?: { __typename?: 'LatLng', lat: number, lng: number, alt?: number | null } | null, config: { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } }, platform?: { __typename?: 'Device', id: string, name: string, aspects: Array<{ __typename?: 'DFA_Avatar', webRtcEnabled?: boolean | null, type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Media', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType }> } | null, zone?: { __typename?: 'ObjectDescriptor', id: string, name: string } | null, set?: Array<{ __typename?: 'ObjectDescriptor', id: string, name: string, isSystemManaged?: boolean | null }> | null, storageConfig?: { __typename?: 'DeviceStorageConfig', storagePool: { __typename?: 'StoragePool', id: string, name: string, ttlHours: number } } | null, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> }> }> };

export type DeviceReportFieldsFragment = { __typename?: 'Device', id: string, name: string, healthStatus: HealthStatus, config: { __typename?: 'DeviceBaseConfig', model?: string | null, configType: DeviceBaseConfigType, connect: { __typename?: 'NetworkConnectDescriptor', host?: string | null } }, aspects: Array<{ __typename?: 'DFA_Avatar', channelStatus?: ChannelStatus | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, type: DeviceFunctionalAspectType, enabled: boolean, software?: { __typename?: 'SoftwareInfo', lastUpdateTime?: Date | null } | null } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType, enabled: boolean } | { __typename?: 'DFA_Media', codec?: string | null, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, type: DeviceFunctionalAspectType, enabled: boolean } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType, enabled: boolean } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType, enabled: boolean } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType, enabled: boolean }>, platform?: { __typename?: 'Device', name: string } | null };

export type DevicesByAspectTypesReportQueryVariables = Exact<{
  types: Array<DeviceFunctionalAspectFilter> | DeviceFunctionalAspectFilter;
}>;


export type DevicesByAspectTypesReportQuery = { __typename?: 'Query', devicesByAspectTypes: Array<{ __typename?: 'Device', id: string, name: string, healthStatus: HealthStatus, config: { __typename?: 'DeviceBaseConfig', model?: string | null, configType: DeviceBaseConfigType, connect: { __typename?: 'NetworkConnectDescriptor', host?: string | null } }, aspects: Array<{ __typename?: 'DFA_Avatar', channelStatus?: ChannelStatus | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, type: DeviceFunctionalAspectType, enabled: boolean, software?: { __typename?: 'SoftwareInfo', lastUpdateTime?: Date | null } | null } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType, enabled: boolean } | { __typename?: 'DFA_Media', codec?: string | null, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, type: DeviceFunctionalAspectType, enabled: boolean } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType, enabled: boolean } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType, enabled: boolean } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType, enabled: boolean }>, platform?: { __typename?: 'Device', name: string } | null }> };

export type DeviceShortFieldsFragment = { __typename?: 'Device', id: string, name: string, location?: string | null, enabled: boolean, healthStatus: HealthStatus, deliveryPriority?: number | null, deviceType?: BaseDeviceType | null, config: { __typename?: 'DeviceBaseConfig', connect: { __typename?: 'NetworkConnectDescriptor', host?: string | null, port?: number | null, URL?: string | null } }, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Media', cloudArchive: MediaArchiveOption, type: DeviceFunctionalAspectType } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType }>, position?: { __typename?: 'LatLng', lat: number, lng: number, alt?: number | null } | null, platform?: { __typename?: 'Device', id: string, name: string } | null, zone?: { __typename?: 'ObjectDescriptor', id: string, name: string } | null };

export type SensorListFieldsFragment = { __typename?: 'Device', id: string, name: string, enabled: boolean, location?: string | null, healthStatus: HealthStatus, zone?: { __typename?: 'ObjectDescriptor', id: string, name: string } | null, platform?: { __typename?: 'Device', id: string, name: string } | null, config: { __typename?: 'DeviceBaseConfig', connect: { __typename?: 'NetworkConnectDescriptor', host?: string | null, port?: number | null } } };

export type GatewayListFieldsFragment = { __typename?: 'Device', id: string, name: string, enabled: boolean, healthStatus: HealthStatus, platform?: { __typename?: 'Device', id: string, name: string } | null, aspects: Array<{ __typename?: 'DFA_Avatar', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, name: string, associatedDevices: Array<string> }> } | { __typename?: 'DFA_Media', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType }> };

export type SensorListByAspectTypeQueryVariables = Exact<{
  types: Array<DeviceFunctionalAspectFilter> | DeviceFunctionalAspectFilter;
}>;


export type SensorListByAspectTypeQuery = { __typename?: 'Query', devicesByAspectTypes: Array<{ __typename?: 'Device', id: string, name: string, enabled: boolean, location?: string | null, healthStatus: HealthStatus, zone?: { __typename?: 'ObjectDescriptor', id: string, name: string } | null, platform?: { __typename?: 'Device', id: string, name: string } | null, config: { __typename?: 'DeviceBaseConfig', connect: { __typename?: 'NetworkConnectDescriptor', host?: string | null, port?: number | null } } }> };

export type GatewayListByAspectTypeQueryVariables = Exact<{
  types: Array<DeviceFunctionalAspectFilter> | DeviceFunctionalAspectFilter;
}>;


export type GatewayListByAspectTypeQuery = { __typename?: 'Query', devicesByAspectTypes: Array<{ __typename?: 'Device', id: string, name: string, enabled: boolean, healthStatus: HealthStatus, platform?: { __typename?: 'Device', id: string, name: string } | null, aspects: Array<{ __typename?: 'DFA_Avatar', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, name: string, associatedDevices: Array<string> }> } | { __typename?: 'DFA_Media', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType }> }> };

export type DeviceWithPlatformByAspectTypeQueryVariables = Exact<{
  types: Array<DeviceFunctionalAspectFilter> | DeviceFunctionalAspectFilter;
}>;


export type DeviceWithPlatformByAspectTypeQuery = { __typename?: 'Query', devicesByAspectTypes: Array<{ __typename?: 'Device', id: string, name: string, platform?: { __typename?: 'Device', id: string } | null }> };

export type DeviceWitnessesByAspectTypeQueryVariables = Exact<{
  types: Array<DeviceFunctionalAspectFilter> | DeviceFunctionalAspectFilter;
}>;


export type DeviceWitnessesByAspectTypeQuery = { __typename?: 'Query', devicesByAspectTypes: Array<{ __typename?: 'Device', id: string, name: string, enabled: boolean, healthStatus: HealthStatus, deviceType?: BaseDeviceType | null, platform?: { __typename?: 'Device', id: string } | null }> };

export type DevicesByAspectTypesShortQueryVariables = Exact<{
  types: Array<DeviceFunctionalAspectFilter> | DeviceFunctionalAspectFilter;
}>;


export type DevicesByAspectTypesShortQuery = { __typename?: 'Query', devicesByAspectTypes: Array<{ __typename?: 'Device', id: string, name: string, location?: string | null, enabled: boolean, healthStatus: HealthStatus, deliveryPriority?: number | null, deviceType?: BaseDeviceType | null, config: { __typename?: 'DeviceBaseConfig', connect: { __typename?: 'NetworkConnectDescriptor', host?: string | null, port?: number | null, URL?: string | null } }, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Media', cloudArchive: MediaArchiveOption, type: DeviceFunctionalAspectType } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType }>, position?: { __typename?: 'LatLng', lat: number, lng: number, alt?: number | null } | null, platform?: { __typename?: 'Device', id: string, name: string } | null, zone?: { __typename?: 'ObjectDescriptor', id: string, name: string } | null }> };

export type DeviceQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DeviceQuery = { __typename?: 'Query', device?: { __typename?: 'Device', id: string, name: string, createdAt?: Date | null, modifiedAt?: Date | null, enabled: boolean, healthStatus: HealthStatus, version: string, location?: string | null, deliveryPriority?: number | null, eventType?: DeviceEventType | null, rtpOverTcp?: boolean | null, rtpTime?: boolean | null, deviceType?: BaseDeviceType | null, position?: { __typename?: 'LatLng', lat: number, lng: number, alt?: number | null } | null, config: { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } }, platform?: { __typename?: 'Device', id: string, name: string, aspects: Array<{ __typename?: 'DFA_Avatar', webRtcEnabled?: boolean | null, type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Media', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType }> } | null, zone?: { __typename?: 'ObjectDescriptor', id: string, name: string } | null, set?: Array<{ __typename?: 'ObjectDescriptor', id: string, name: string, isSystemManaged?: boolean | null }> | null, storageConfig?: { __typename?: 'DeviceStorageConfig', storagePool: { __typename?: 'StoragePool', id: string, name: string, ttlHours: number } } | null, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> }> } | null };

export type DeviceForPlayerQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DeviceForPlayerQuery = { __typename?: 'Query', device?: { __typename?: 'Device', id: string, name: string, cloudDirect: boolean, aspects: Array<{ __typename?: 'DFA_Avatar', enabled: boolean } | { __typename?: 'DFA_Gateway', enabled: boolean } | { __typename?: 'DFA_Media', streamType: MediaStreamType, enabled: boolean } | { __typename?: 'DFA_PTZ', enabled: boolean } | { __typename?: 'DFA_Sensor', enabled: boolean } | { __typename?: 'DFA_VAE', enabled: boolean }>, platform?: { __typename?: 'Device', aspects: Array<{ __typename?: 'DFA_Avatar', webRtcEnabled?: boolean | null } | { __typename?: 'DFA_Gateway' } | { __typename?: 'DFA_Media' } | { __typename?: 'DFA_PTZ' } | { __typename?: 'DFA_Sensor' } | { __typename?: 'DFA_VAE' }> } | null } | null };

export type DevicesByIdsQueryVariables = Exact<{
  ids: Array<Scalars['ID']> | Scalars['ID'];
}>;


export type DevicesByIdsQuery = { __typename?: 'Query', devicesByIds: Array<{ __typename?: 'Device', id: string, name: string, createdAt?: Date | null, modifiedAt?: Date | null, enabled: boolean, healthStatus: HealthStatus, version: string, location?: string | null, deliveryPriority?: number | null, eventType?: DeviceEventType | null, rtpOverTcp?: boolean | null, rtpTime?: boolean | null, deviceType?: BaseDeviceType | null, position?: { __typename?: 'LatLng', lat: number, lng: number, alt?: number | null } | null, config: { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } }, platform?: { __typename?: 'Device', id: string, name: string, aspects: Array<{ __typename?: 'DFA_Avatar', webRtcEnabled?: boolean | null, type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Gateway', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Media', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_PTZ', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_Sensor', type: DeviceFunctionalAspectType } | { __typename?: 'DFA_VAE', type: DeviceFunctionalAspectType }> } | null, zone?: { __typename?: 'ObjectDescriptor', id: string, name: string } | null, set?: Array<{ __typename?: 'ObjectDescriptor', id: string, name: string, isSystemManaged?: boolean | null }> | null, storageConfig?: { __typename?: 'DeviceStorageConfig', storagePool: { __typename?: 'StoragePool', id: string, name: string, ttlHours: number } } | null, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> }> }> };

export type DeviceNameQueryVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DeviceNameQuery = { __typename?: 'Query', device?: { __typename?: 'Device', id: string, name: string } | null };

export type ArchiveCoverageQueryVariables = Exact<{
  ids: Array<Scalars['ID']> | Scalars['ID'];
  startTime: Scalars['DateTime'];
  endTime: Scalars['DateTime'];
}>;


export type ArchiveCoverageQuery = { __typename?: 'Query', archiveCoverage: { __typename?: 'ArchiveCoverage', coverage: Array<{ __typename?: 'ArchiveCoverageItem', deviceId: string, streamNumber: number, time: number }>, partialCoverage: Array<{ __typename?: 'ArchiveCoverageItem', deviceId: string, streamNumber: number, time: number }>, ttl: Array<{ __typename?: 'ArchiveCoverageTTL', deviceId: string, ttl: number }> }, aodGet: Array<{ __typename?: 'AodRequest', id: string, deviceId: string, startTime: Date, endTime: Date, streamNumber: number, status: AodRequestStatus }> };

export type ArchiveBoundaryQueryVariables = Exact<{
  ids: Array<Scalars['ID']> | Scalars['ID'];
  streamNumbers: Array<Scalars['Int']> | Scalars['Int'];
  startTime: Scalars['DateTime'];
  find: BoundaryFind;
}>;


export type ArchiveBoundaryQuery = { __typename?: 'Query', archiveBoundary: { __typename?: 'ArchiveBoundary', boundary?: Date | null, timeInsideGap: boolean } };

export type ProbeDeviceQueryVariables = Exact<{
  input: DeviceProbeInput;
}>;


export type ProbeDeviceQuery = { __typename?: 'Query', probeDevice: { __typename?: 'DeviceProbe', name?: string | null, snapshots: Array<string>, rtpTime?: boolean | null, config: { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } }, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> }> } };

export type DiscoverDevicesQueryVariables = Exact<{
  platformId: Scalars['ID'];
}>;


export type DiscoverDevicesQuery = { __typename?: 'Query', discoverDevices: Array<{ __typename?: 'DeviceProbe', name?: string | null, snapshots: Array<string>, rtpTime?: boolean | null, config: { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } }, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> }> }> };

export type ProbeSensorQueryVariables = Exact<{
  input: DeviceProbeInput;
}>;


export type ProbeSensorQuery = { __typename?: 'Query', probeSensorDevice: { __typename?: 'DeviceProbe', name?: string | null, snapshots: Array<string>, rtpTime?: boolean | null, config: { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } }, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> }> } };

export type StoragePoolsQueryVariables = Exact<{ [key: string]: never; }>;


export type StoragePoolsQuery = { __typename?: 'Query', storagePools: Array<{ __typename?: 'StoragePool', id: string, name: string, ttlHours: number }> };

export type AspectTemplatesQueryVariables = Exact<{ [key: string]: never; }>;


export type AspectTemplatesQuery = { __typename?: 'Query', aspectTemplates: Array<{ __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }> };

export type DeviceTemplatesQueryVariables = Exact<{ [key: string]: never; }>;


export type DeviceTemplatesQuery = { __typename?: 'Query', deviceTemplates: Array<{ __typename?: 'DeviceTemplate', make: string, models: Array<{ __typename?: 'DeviceTemplateModel', model: string, url: string }> }> };

export type VaeTemplatesQueryVariables = Exact<{
  deviceId: Scalars['ID'];
}>;


export type VaeTemplatesQuery = { __typename?: 'Query', vaeTemplates: Array<{ __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }> };

export type CameraLogQueryVariables = Exact<{
  deviceId: Scalars['ID'];
}>;


export type CameraLogQuery = { __typename?: 'Query', cameraLog: Array<{ __typename?: 'CameraLog', time: Date, severity: LogSeverity, message: string }> };

export type VaeConfigsQueryVariables = Exact<{
  deviceId: Scalars['ID'];
  engine: Scalars['String'];
}>;


export type VaeConfigsQuery = { __typename?: 'Query', vaeConfigs: Array<{ __typename?: 'VaeConfigBrief', name: string }> };

export type ProbeGatewayDirectoriesQueryVariables = Exact<{
  input: GatewayDirectoriesProbeInput;
}>;


export type ProbeGatewayDirectoriesQuery = { __typename?: 'Query', probeGatewayDirectories: { __typename?: 'GatewayDirectoriesProbe', deviceProbe: { __typename?: 'DeviceProbe', name?: string | null, snapshots: Array<string>, rtpTime?: boolean | null, config: { __typename?: 'DeviceBaseConfig', configType: DeviceBaseConfigType, make?: string | null, model?: string | null, firmware?: string | null, onvifServices?: string | null, connect: { __typename?: 'NetworkConnectDescriptor', authType: AuthType, URL?: string | null, host?: string | null, user?: string | null, pass?: string | null, port?: number | null, rtspPort?: number | null, protocol?: ProtocolType | null } }, aspects: Array<{ __typename?: 'DFA_Avatar', isLink?: boolean | null, channelStatus?: ChannelStatus | null, dsConfiguredState?: DsConfiguredState | null, dsRunningState?: DsRunningState | null, lastStatusUpdate?: Date | null, statusUpdateInterval?: number | null, vmxVideoStreamingMode?: VmxVideoStreamingMode | null, vaeImageUpdate?: boolean | null, webRtcEnabled?: boolean | null, uploadBandwidthCap?: number | null, platform?: string | null, upTime?: number | null, avatarLoad?: number | null, deliveryQueue?: number | null, deliveryQueueUploadTime?: number | null, turnaroundTime?: number | null, supportsReboot?: boolean | null, pushEventEndPoint?: string | null, apiKey?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, storageUsage?: { __typename?: 'StorageUsage', free?: number | null, requiredVolume?: number | null, localStorageVolume?: number | null } | null, software?: { __typename?: 'SoftwareInfo', version?: string | null, updateAvailable?: boolean | null, lastUpdateTime?: Date | null, lastUpdateSucceeded?: boolean | null } | null, channelBenchmark?: { __typename?: 'ChannelBenchmark', startedAt?: Date | null, error?: string | null, tcpDown?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null, tcpUp?: { __typename?: 'ChannelStatistics', bytes?: number | null, bitsPerSecond?: number | null } | null } | null, encryptionKey?: { __typename?: 'EncryptionKeyInfo', isValid?: boolean | null, issuedAt?: Date | null } | null, channelTurnaroundTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, packetArrivalJitterTime?: { __typename?: 'StatTime', avg: number, max: number, min: number } | null, vaeUpdates?: Array<{ __typename?: 'VaeUpdate', name: string, status: VaeUpdateStatus, version?: string | null, log?: Array<string> | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Gateway', lenelVersion: string, oidcToken?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, directory: { __typename?: 'GatewayDirectory', id: string, name: string }, associatedGatewayDevices: Array<{ __typename?: 'AssociatedGatewayDevice', id: string, associatedDevices: Array<string> }>, subscribedEvents: Array<{ __typename?: 'GatewayEvent', id: string, type: string }>, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }>, devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }>, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Media', streamType: MediaStreamType, URL?: string | null, videoWidth?: number | null, videoHeight?: number | null, codec?: string | null, frameRate?: number | null, onvifProfile?: string | null, onvifProfiles?: any | null, edgeArchive: MediaArchiveOption, cloudArchive: MediaArchiveOption, consumedSpace?: number | null, spaceUsageHour?: number | null, spaceUsageDay?: number | null, FPS?: number | null, liveBitrate?: number | null, uptime?: number | null, averageFPS?: number | null, averageGOP?: number | null, averageInterArrivalJitter?: number | null, rtpPacketLost?: number | null, videoCodec?: string | null, videoSize?: string | null, audioCodec?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sharedStream?: Array<{ __typename?: 'StreamShare', id: number, url: string, error?: string | null, status?: HealthStatus | null }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_PTZ', ptzPanInverted?: boolean | null, ptzTiltInverted?: boolean | null, ptzConfig?: string | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_Sensor', model?: string | null, serial?: string | null, userEvents?: Array<string> | null, associatedDevices?: Array<string> | null, category?: AspectSensorCategory | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, sensorEvents?: Array<{ __typename?: 'SensorEvent', type: string, description: string }> | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> } | { __typename?: 'DFA_VAE', vaeFeatures?: Array<string> | null, id: string, type: DeviceFunctionalAspectType, name: string, enabled: boolean, vaeConfig?: { __typename?: 'VaeConfigFull', name: string, description: string, configuration: any } | null, template: { __typename?: 'FunctionalAspectTemplate', id: string, type: DeviceFunctionalAspectType, name: string, order: number, engine?: string | null, features?: Array<{ __typename?: 'VaeFeature', id: string, name: string, order: number, exclusive?: boolean | null }> | null }, device?: { __typename?: 'Device', id: string, name: string } | null, health: { __typename?: 'AspectHealth', gravity: Fa_HealthGravity, readinessTimeout: number, livenessTimeout: number, healthStatus: HealthStatus }, inputAspects: Array<{ __typename?: 'DFA_Avatar', id: string, name: string } | { __typename?: 'DFA_Gateway', id: string, name: string } | { __typename?: 'DFA_Media', id: string, name: string } | { __typename?: 'DFA_PTZ', id: string, name: string } | { __typename?: 'DFA_Sensor', id: string, name: string } | { __typename?: 'DFA_VAE', id: string, name: string }> }> }, directories: Array<{ __typename?: 'GatewayDirectory', id: string, name: string }> } };

export type ProbeGatewayQueryVariables = Exact<{
  input: GatewayProbeInput;
}>;


export type ProbeGatewayQuery = { __typename?: 'Query', probeGateway: { __typename?: 'GatewayProbe', devices: Array<{ __typename?: 'GatewayProbeDevice', id: string, name: string }>, events: Array<{ __typename?: 'GatewayProbeEvent', id: string, name: string }> } };

export type CreateGatewayMutationVariables = Exact<{
  device: DeviceInput;
}>;


export type CreateGatewayMutation = { __typename?: 'Mutation', createGatewayDevice: { __typename?: 'CreateResult', id: string, warning?: string | null } };

export type CreateSensorMutationVariables = Exact<{
  device: DeviceInput;
}>;


export type CreateSensorMutation = { __typename?: 'Mutation', createSensorDevice: { __typename?: 'CreateResult', id: string, warning?: string | null } };

export type CreateDeviceMutationVariables = Exact<{
  device: DeviceInput;
}>;


export type CreateDeviceMutation = { __typename?: 'Mutation', createDevice: { __typename?: 'CreateResult', id: string, warning?: string | null } };

export type UpdateDeviceMutationVariables = Exact<{
  id: Scalars['ID'];
  device: DeviceInput;
}>;


export type UpdateDeviceMutation = { __typename?: 'Mutation', updateDevice: { __typename?: 'UpdateResult', updated: boolean, warning?: string | null, warningFields?: Array<{ __typename?: 'WarningField', field?: string | null, value?: string | null }> | null } };

export type UpdatePositionMutationVariables = Exact<{
  id: Scalars['ID'];
  position: LatLngInput;
}>;


export type UpdatePositionMutation = { __typename?: 'Mutation', updatePosition: boolean };

export type DeleteDeviceMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type DeleteDeviceMutation = { __typename?: 'Mutation', deleteDevice: boolean };

export type DeviceCommandMutationVariables = Exact<{
  id: Scalars['ID'];
  command: DeviceCommand;
}>;


export type DeviceCommandMutation = { __typename?: 'Mutation', deviceCommand: boolean };

export type ChangeDeliveryPriorityMutationVariables = Exact<{
  devices: Array<DeliveryPriorityInput> | DeliveryPriorityInput;
}>;


export type ChangeDeliveryPriorityMutation = { __typename?: 'Mutation', changeDeliveryPriority: boolean };

export type CreateVaeConfigMutationVariables = Exact<{
  deviceId: Scalars['ID'];
  engine: Scalars['String'];
  name: Scalars['String'];
}>;


export type CreateVaeConfigMutation = { __typename?: 'Mutation', createVaeConfig: boolean };

export type RenameVaeConfigMutationVariables = Exact<{
  deviceId: Scalars['ID'];
  engine: Scalars['String'];
  name: Scalars['String'];
  newName: Scalars['String'];
}>;


export type RenameVaeConfigMutation = { __typename?: 'Mutation', renameVaeConfig: boolean };

export type DeleteVaeConfigMutationVariables = Exact<{
  deviceId: Scalars['ID'];
  engine: Scalars['String'];
  name: Scalars['String'];
}>;


export type DeleteVaeConfigMutation = { __typename?: 'Mutation', deleteVaeConfig: boolean };

export type PurgeAvatarQueueMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type PurgeAvatarQueueMutation = { __typename?: 'Mutation', purgeAvatarQueue: boolean };

export type PtzStepMutationVariables = Exact<{
  id: Scalars['ID'];
  command: Ptz_StepInput;
  priority?: InputMaybe<Scalars['Int']>;
}>;


export type PtzStepMutation = { __typename?: 'Mutation', ptzStep: boolean };

export type PtzSpeedMutationVariables = Exact<{
  id: Scalars['ID'];
  command: Ptz_SpeedInput;
  priority?: InputMaybe<Scalars['Int']>;
}>;


export type PtzSpeedMutation = { __typename?: 'Mutation', ptzSpeed: boolean };

export type PtzPresetMutationVariables = Exact<{
  id: Scalars['ID'];
  command: Ptz_PresetInput;
  priority?: InputMaybe<Scalars['Int']>;
}>;


export type PtzPresetMutation = { __typename?: 'Mutation', ptzPreset: boolean };

export type PtzRelMutationVariables = Exact<{
  id: Scalars['ID'];
  command: Ptz_RelInput;
  priority?: InputMaybe<Scalars['Int']>;
}>;


export type PtzRelMutation = { __typename?: 'Mutation', ptzRel: boolean };

export type ChangeLocalStorageConfigMutationVariables = Exact<{
  id: Scalars['ID'];
  input: LocalStorageInput;
}>;


export type ChangeLocalStorageConfigMutation = { __typename?: 'Mutation', changeLocalStorage: boolean };

export type CreateAvatarApiKeyMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type CreateAvatarApiKeyMutation = { __typename?: 'Mutation', createAvatarApiKey: boolean };

export type RegenerateAvatarApiKeyMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type RegenerateAvatarApiKeyMutation = { __typename?: 'Mutation', regenerateAvatarApiKey: boolean };

export type RemoveAvatarApiKeyMutationVariables = Exact<{
  id: Scalars['ID'];
}>;


export type RemoveAvatarApiKeyMutation = { __typename?: 'Mutation', removeAvatarApiKey: boolean };
