export type EventPubSubFunc<TArgs> = (args: TArgs) => void;

export class EventPubSub<TArgs, TFunc extends EventPubSubFunc<TArgs> = EventPubSubFunc<TArgs>> {
  private readonly subscriptions = new Map<string, TFunc>();
  private disabled = false;

  subscribe(id: string, func: TFunc): void {
    this.subscriptions.set(id, func);
  }

  unsubscribe(id: string): void {
    this.subscriptions.delete(id);
  }

  publish(args: TArgs): void {
    if (!this.disabled) {
      for (const func of Array.from(this.subscriptions.values())) {
        func(args);
      }
    }
  }

  get subscribersCount(): number {
    return this.subscriptions.size;
  }

  unsubscribeAll(): void {
    this.subscriptions.clear();
  }

  disable(): void {
    this.disabled = true;
  }

  enable(): void {
    this.disabled = false;
  }
}

export type FilterArgs = {
  filter: string;
  key?: string;
};

export class FilterEvent extends EventPubSub<FilterArgs> {}
