export const linkActivationSteps = [
  {
    id: "welcome_step",
    buttons: [
      {
        classes: "ui button",
        text: "Exit",
        type: "cancel"
      },
      {
        classes: "ui positive button",
        text: "Next",
        type: "next"
      }
    ],
    scrollTo: false,
    cancelIcon: {
      enabled: true,
    },
    title: "Welcome to Solid UI!",
    text: ["Let us introduce how activate Avatar in our application"],
  },
  {
    showOn() {
      return !(document.getElementsByClassName("linkProvision").length > 0);
    },
    id: "devices_step",
    attachTo: {
      element: ".Devices",
      on: "auto"
    },
    buttons: [
      {
        classes: "ui button positive",
        text: "Exit",
        type: "cancel"
      },
    ],
    title: "Click this tab",
    text: ["To activate Avatar you need to do this via 'Devices' section"],
    advanceOn: {
      selector: ".Devices",
      event: "click"
    },
  },
  {
    showOn() {
      return !(document.getElementsByClassName("Refresh_button").length > 0);
    },
    beforeShowPromise() {
      return new Promise((resolve) => {
        setTimeout(() => {
          resolve(document.getElementsByClassName(".linkProvision"));
        }, 100);
      });
    },
    id: "link-activation_step",
    attachTo: {
      element: ".linkProvision",
      on: "left-end"
    },
    buttons: [
      {
        classes: "ui positive button",
        text: "Exit",
        type: "cancel"
      },
    ],
    title: "Click Avatar activation",
    text: ["Next step you should click 'Avatar Activation'"],
    advanceOn: {
      selector: ".linkProvision",
      event: "click"
    },
  },
  {
    showOn() {
      return !(document.getElementsByClassName("Activate").length > 0);
    },
    beforeShowPromise() {
      return new Promise((resolve) => {
        setTimeout(() => {
          resolve(document.getElementsByClassName(".Refresh_button"));
        }, 100);
      });
    },
    id: "refresh_step",
    attachTo: {
      element: ".LinkProvision-Top",
      on: "left"
    },
    buttons: [
      {
        classes: "ui positive button",
        text: "Cancel",
        type: "cancel"
      },
    ],
    scrollTo: false,
    cancelIcon: {
      enabled: true,
    },
    title: "Refresh",
    text: ["Please click refresh button"],
    advanceOn: {
      selector: ".Refresh_button",
      event: "click"
    },
  },
  {
    beforeShowPromise() {
      return new Promise((resolve) => {
        setTimeout(() => {
          resolve(document.getElementsByClassName(".Activate"));
        }, 500);
      });
    },
    showOn() {
      return (document.getElementsByClassName("Activate").length > 0);
    },
    id: "refresh_step",
    attachTo: {
      element: ".Activate",
      on: "auto"
    },
    buttons: [
      {
        classes: "ui positive button",
        text: "Complete",
        type: "cancel"
      },
    ],
    scrollTo: false,
    cancelIcon: {
      enabled: true,
    },
    title: "Complete",
    text: ["To complete the activation of the Avatar, click the button 'Activate'"],
    advanceOn: {
      selector: ".Activate",
      event: "click"
    },
  },
  {
    beforeShowPromise() {
      return new Promise((resolve) => {
        setTimeout(() => {
          resolve(document.getElementsByClassName(".Activate"));
        }, 500);
      });
    },
    showOn() {
      return !(document.getElementsByClassName("Activate").length > 0);
    },
    id: "refresh_step",
    attachTo: {
      element: ".Activate",
      on: "auto"
    },
    buttons: [
      {
        classes: "ui positive button",
        text: "Complete",
        type: "cancel"
      },
    ],
    scrollTo: false,
    cancelIcon: {
      enabled: true,
    },
    title: "Completed",
    text: ["Your links are activated or missing, try clicking the 'Refresh' button again, and then the 'Activate' button."],
  }
];
