export const createDeviceTour = [
  {
    id: "welcome_step",
    buttons: [
      {
        classes: "ui button",
        text: "Exit",
        type: "cancel"
      },
      {
        classes: "ui button",
        text: "Back",
        type: "back"
      },
      {
        classes: "ui positive button",
        text: "Next",
        type: "next"
      }
    ],
    scrollTo: false,
    cancelIcon: {
      enabled: true,
    },
    title: "Welcome to Solid UI!",
    text: ["Let us introduce how create device in our app"],
  },
  {
    id: "devices_step",
    attachTo: {
      element: ".Devices",
      on: "auto"
    },
    buttons: [
      {
        classes: "ui button",
        text: "Exit",
        type: "cancel"
      },
      {
        classes: "ui button",
        text: "Back",
        type: "back"
      },
      // {
      //   classes: "ui positive button",
      //   text: "Next",
      //   type: "next"
      // }
    ],
    text: ["To create new device you need to do this via 'Devices' section"],
    advanceOn: {
      selector: ".Devices",
      event: "click"
    }
  },
  {
    id: "device-item-step",
    attachTo: {
      element: ".devices",
      on: "auto"
    },
    buttons: [
      {
        classes: "ui button",
        text: "Exit",
        type: "cancel"
      },
      {
        classes: "ui button",
        text: "Back",
        type: "back"
      },
      {
        classes: "ui positive button",
        text: "Next",
        type: "next"
      }
    ],
    scrollTo: false,
    cancelIcon: {
      enabled: true,
    },
    title: "Click Devices",
    text: ["Next step you should click 'Devices'"],
  },
  {
    id: "create-step",
    attachTo: {
      element: ".create-device",
      on: "auto"
    },
    buttons: [
      {
        classes: "ui button",
        text: "Exit",
        type: "cancel"
      },
      {
        classes: "ui button",
        text: "Back",
        type: "back"
      },
      {
        classes: "ui positive button",
        text: "Next",
        type: "next"
      }
    ],
    scrollTo: false,
    cancelIcon: {
      enabled: true,
    },
    title: "Click Create",
    text: ["Next step you should click 'Create +'"],
  },
  {
    id: "fill_form_step",
    attachTo: {
      element: ".CreateUpdateCamera-Tab",
      on: "left"
    },
    buttons: [
      {
        classes: "ui button",
        text: "Exit",
        type: "cancel"
      },
      {
        classes: "ui button",
        text: "Back",
        type: "back"
      },
      {
        classes: "ui positive button",
        text: "Next",
        type: "next"
      }
    ],
    scrollTo: false,
    cancelIcon: {
      enabled: true,
    },
    title: "Fill form",
    text: ["Please fill form to set up a new device"],
  },
  {
    id: "test-step",
    attachTo: {
      element: ".play-test-btn",
      on: "auto"
    },
    buttons: [
      {
        classes: "ui button",
        text: "Exit",
        type: "cancel"
      },
      {
        classes: "ui button",
        text: "Back",
        type: "back"
      },
      {
        classes: "ui positive button",
        text: "Next",
        type: "next"
      }
    ],
    scrollTo: false,
    cancelIcon: {
      enabled: true,
    },
    title: "Test and Play",
    text: ["Click test button to start using your device"],
  },
  {
    id: "config-step1",
    attachTo: {
      element: ".next-btn",
      on: "auto"
    },
    buttons: [
      {
        classes: "ui button",
        text: "Exit",
        type: "cancel"
      },
      {
        classes: "ui button",
        text: "Back",
        type: "back"
      },
      {
        classes: "ui positive button",
        text: "Next",
        type: "next"
      }
    ],
    scrollTo: false,
    cancelIcon: {
      enabled: true,
    },
    title: "Test and Play",
    text: ["Click test button to start using your device"],
  },
  {
    id: "config-step2",
    attachTo: {
      element: ".next-btn",
      on: "auto"
    },
    buttons: [
      {
        classes: "ui button",
        text: "Exit",
        type: "cancel"
      },
      {
        classes: "ui button",
        text: "Back",
        type: "back"
      },
      {
        classes: "ui positive button",
        text: "Next",
        type: "next"
      }
    ],
    scrollTo: false,
    cancelIcon: {
      enabled: true,
    },
    title: "Test and Play",
    text: ["Click test button to start using your device"],
  },
  {
    id: "final-create",
    attachTo: {
      element: ".final-create-btn",
      on: "auto"
    },
    buttons: [
      {
        classes: "ui button",
        text: "Exit",
        type: "cancel"
      },
      {
        classes: "ui button",
        text: "Back",
        type: "back"
      },
      {
        classes: "ui positive button",
        text: "Next",
        type: "next"
      }
    ],
    scrollTo: false,
    cancelIcon: {
      enabled: true,
    },
    title: "Test and Play",
    text: ["Click test button to start using your device"],
  }
];
