import React  from "react";
import TestRenderer, {act} from "react-test-renderer";
import { MockedProvider } from "@apollo/client/testing";
import { GET_DOG_QUERY, Some } from "components/Some/Some";

const mocks = [
  {
    request: {
      query: GET_DOG_QUERY,
      variables: {
        name: "Buck",
      },
    },
    result: {
      data: {
        dog: { id: "1", name: "Buck", breed: "bulldog" },
      },
    },
  },
]; // We'll fill this in next

it("renders without error", () => {
  const component = TestRenderer.create(
    <MockedProvider mocks={mocks} addTypename={false}>
      <Some name="Buck"/>
    </MockedProvider>,
  );

  const tree: any = component.toJSON();
  expect(tree.children).toContain("Loading...");
});

it("should render dog", async () => {
  const component = await TestRenderer.create(
    <MockedProvider mocks={mocks} addTypename={false}>
      <Some name="Buck" />
    </MockedProvider>,
  );
  await act(() => new Promise(resolve => setTimeout(resolve, 0)));

  const p = await component.root.findByType("p");
  await expect(p.children.join("")).toContain("Buck is a bulldog");
});

it("error on server", async () => {
  const component = await TestRenderer.create(
    <MockedProvider mocks={[]} addTypename={false}>
      <Some name="" />
    </MockedProvider>,
  );
  await act(() => new Promise(resolve => setTimeout(resolve, 0)));

  const p = await component.root.findByType("p");
  await expect(p.children.join("")).toContain("Error!");
});
